"""
URL configuration for BackEnd project.

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/5.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path, include,re_path
from wagtail.admin import urls as wagtailadmin_urls
from django.conf import settings
from django.conf.urls.static import static
from wagtail.images.views.serve import ServeView
from django.views.static import serve
from django.views.generic import TemplateView
from rest_framework_simplejwt.views import (
    TokenObtainPairView,
    TokenRefreshView,TokenVerifyView
)
from django.http import HttpResponse

# from debug_toolbar.toolbar import debug_toolbar_urls
from wagtail.documents import urls as wagtaildocs_urls
from web.views import service_detail
urlpatterns = [
    
    path('documents/', include(wagtaildocs_urls)),

    path('django-admin/', admin.site.urls),
    path('admin/', include(wagtailadmin_urls)),
    path('api/',include('useraccess.urls')),
    path('api/',include('core.urls')),
    path('api/',include('web.urls')),
    # path('api/token/', TokenObtainPairView.as_view(), name='token_obtain_pair'),
    path('api/token/refresh/', TokenRefreshView.as_view(), name='token_refresh'),
    path('api/token/verify/', TokenVerifyView.as_view(), name='token_verify'),

   
    path("", TemplateView.as_view(template_name="index.html")),
    path("home/", TemplateView.as_view(template_name="index.html")),
    path("<slug>/", TemplateView.as_view(template_name="index.html")),
    path("our-clients/", TemplateView.as_view(template_name="index.html")),
    path("industries/", TemplateView.as_view(template_name="index.html")),
    path("services/", TemplateView.as_view(template_name="index.html")),
    path("services/<slug>/", TemplateView.as_view(template_name="index.html")),
    path("services/<slug:category_slug>/<slug:service_slug>/", service_detail, name='service_detail'),
    # path("services/<slug>/<slug>/", TemplateView.as_view(template_name="index.html")),
    path("policy/<slug>/", TemplateView.as_view(template_name="index.html")),
    path("login/", TemplateView.as_view(template_name="index.html")),
    path("dashboard/", TemplateView.as_view(template_name="index.html")),
    path("view/<id>/", TemplateView.as_view(template_name="index.html")),
    path("follow-up/<id>/", TemplateView.as_view(template_name="index.html")),
    
    re_path(r'^media/(?P<path>.*)$', serve,
            {'document_root': settings.MEDIA_ROOT}),
    re_path(r'^static/(?P<path>.*)$', serve,
            {'document_root': settings.STATIC_ROOT}),

]
if settings.DEBUG:
    # urlpatterns+= debug_toolbar_urls()
    urlpatterns += static(settings.MEDIA_URL,
                          document_root=settings.MEDIA_ROOT)
    urlpatterns += static(settings.STATIC_URL,
                          document_root=settings.STATIC_ROOT)


