# consumers.py
import json
from channels.generic.websocket import AsyncWebsocketConsumer

class ThemeSettingsConsumer(AsyncWebsocketConsumer):
    async def connect(self):
        await self.channel_layer.group_add("theme_updates", self.channel_name)
        await self.accept()

    async def disconnect(self, close_code):
        await self.channel_layer.group_discard("theme_updates", self.channel_name)

    async def receive(self, text_data):
        # Optional: handle client messages if needed
        pass

    async def send_theme_update(self, event):
        await self.send(text_data=json.dumps(event["data"]))
