# Generated by Django 5.2.4 on 2025-07-19 06:05

import django.db.models.deletion
import wagtail_color_panel.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('wagtailcore', '0094_alter_page_locale'),
        ('wagtailimages', '0027_image_description'),
    ]

    operations = [
        migrations.CreateModel(
            name='CompanyHoliday',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(unique=True)),
                ('name', models.CharField(max_length=100)),
                ('is_national_holiday', models.BooleanField(default=False)),
            ],
            options={
                'verbose_name': 'Company Holiday',
                'verbose_name_plural': 'Company Holidays',
                'ordering': ['date'],
            },
        ),
        migrations.CreateModel(
            name='FontType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('font', models.CharField(blank=True, max_length=250, null=True, verbose_name='Font Name')),
            ],
            options={
                'verbose_name': 'Font Type',
                'verbose_name_plural': 'Font Types',
                'ordering': ['font'],
            },
        ),
        migrations.CreateModel(
            name='IdentityType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(max_length=150, verbose_name='Entry Name')),
                ('docName', models.CharField(max_length=150, verbose_name='Document Name')),
                ('typeFormat', models.CharField(blank=True, max_length=150, null=True)),
                ('typeLength', models.PositiveIntegerField(blank=True, null=True)),
                ('placeholder', models.CharField(blank=True, max_length=200, null=True)),
                ('message', models.CharField(blank=True, max_length=200, null=True)),
                ('progress', models.BooleanField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='SiteLogo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('logo', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.site')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ThemeSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('topHeaderBgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='BG Color')),
                ('topHeaderFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='FG Color')),
                ('topHeaderHoverBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Hover BG Color')),
                ('topHeaderHoverFgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover FG Color')),
                ('topHeaderSelectedBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected BG Color')),
                ('topHeaderSelectedFgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Selected FG Color')),
                ('topHeaderFontSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Font Size')),
                ('topHeaderIconSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Icon Size')),
                ('web_topHeaderBgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='BG Color')),
                ('web_topHeaderFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='FG Color')),
                ('web_topHeaderHoverBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Hover BG Color')),
                ('web_topHeaderHoverFgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover FG Color')),
                ('web_topHeaderSelectedBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected BG Color')),
                ('web_topHeaderSelectedFgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Selected FG Color')),
                ('web_topHeaderFontSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Font Size')),
                ('web_topHeaderIconSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Icon Size')),
                ('web_headerBgColor', wagtail_color_panel.fields.ColorField(blank=True, max_length=7, null=True, verbose_name='BG Color')),
                ('web_headerGradientBgColor', models.TextField(blank=True, null=True, verbose_name='Fill-Effect combination')),
                ('web_headerFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='FG Color')),
                ('web_headerHoverBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Hover BG Color')),
                ('web_headerHoverFgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover FG Color')),
                ('web_headerSelectedBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected BG Color')),
                ('web_headerSelectedFgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Selected FG Color')),
                ('web_headerSelectedPosition', models.CharField(blank=True, choices=[(None, 'None'), ('Top', 'Top'), ('Bottom', 'Bottom')], default=None, max_length=200, null=True)),
                ('web_headerFontSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Font Size')),
                ('web_headerIconSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Icon Size')),
                ('mobile_headerBgColor', wagtail_color_panel.fields.ColorField(blank=True, max_length=7, null=True, verbose_name='BG Color')),
                ('mobile_headerGradientBgColor', models.TextField(blank=True, null=True, verbose_name='Fill-Effect combination')),
                ('mobile_headerFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='FG Color')),
                ('mobile_headerLogoSize', models.CharField(blank=True, choices=[(None, 'None'), ('Big', 'Big'), ('Medium', 'Medium'), ('Small', 'Small')], max_length=200, null=True, verbose_name='Logo Size')),
                ('mobile_headerMenuIcon', models.CharField(blank=True, max_length=200, null=True, verbose_name='Menu Icon')),
                ('mobile_headerCancelIcon', models.CharField(blank=True, max_length=200, null=True, verbose_name='Cancel Icon')),
                ('mobile_headerCancelBg', wagtail_color_panel.fields.ColorField(default='#810000', max_length=7, verbose_name='Cancel BG Color')),
                ('mobile_headerCancelFg', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Cancel FG Color')),
                ('footerBgColor', wagtail_color_panel.fields.ColorField(blank=True, max_length=7, null=True, verbose_name='BG Color')),
                ('footerGradientBgColor', models.TextField(blank=True, null=True, verbose_name='Fill-Effect combination')),
                ('footerFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='FG Color')),
                ('footerHoverBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Hover BG Color')),
                ('footerHoverFgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover FG Color')),
                ('footerSelectedBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected BG Color')),
                ('footerSelectedFgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Selected FG Color')),
                ('footerFontSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Font Size')),
                ('footerIconSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Icon Size')),
                ('footerAccordinExpandIcon', models.CharField(blank=True, default=None, max_length=200, null=True, verbose_name='Accordion Expand Icon')),
                ('footerAccordinCollapseIcon', models.CharField(blank=True, default=None, max_length=200, null=True, verbose_name='Accordion Collapse Icon')),
                ('web_footerBgColor', wagtail_color_panel.fields.ColorField(blank=True, max_length=7, null=True, verbose_name='BG Color')),
                ('web_footerGradientBgColor', models.TextField(blank=True, null=True, verbose_name='Fill-Effect combination')),
                ('web_footerFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='FG Color')),
                ('web_footerHoverBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Hover BG Color')),
                ('web_footerHoverFgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover FG Color')),
                ('web_footerSelectedBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected BG Color')),
                ('web_footerSelectedFgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Selected FG Color')),
                ('web_footerFontSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Font Size')),
                ('web_footerIconSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Icon Size')),
                ('mob_foot_menuBgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='BG Color')),
                ('mob_foot_menuFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='FG Color')),
                ('mob_foot_menuHoverBgColor', wagtail_color_panel.fields.ColorField(default='#1E1A1A', max_length=7, verbose_name='Hover BG Color')),
                ('mob_foot_menuHoverFgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover FG Color')),
                ('mob_foot_menuSelectedBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected BG Color')),
                ('mob_foot_menuSelectedFgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Selected FG Color')),
                ('mob_foot_menuSelectedPosition', models.CharField(blank=True, choices=[(None, 'None'), ('Top', 'Top'), ('Bottom', 'Bottom')], default=None, max_length=200, null=True)),
                ('mob_foot_menuFontSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Font Size')),
                ('mob_foot_menuIconSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Icon Size')),
                ('mob_foot_menuMenuIcon', models.CharField(blank=True, max_length=200, null=True, verbose_name='Menu Icon')),
                ('mob_foot_menuCancelIcon', models.CharField(blank=True, max_length=200, null=True, verbose_name='Cancel Icon')),
                ('mob_foot_menuCancelBg', wagtail_color_panel.fields.ColorField(default='#810000', max_length=7, verbose_name='Cancel BG Color')),
                ('mob_foot_menuCancelFg', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Cancel FG Color')),
                ('burgerMenuBgColor', wagtail_color_panel.fields.ColorField(blank=True, max_length=7, null=True, verbose_name='BG Color')),
                ('burgerMenuGradientBgColor', models.TextField(blank=True, null=True, verbose_name='Fill-Effect combination')),
                ('burgerMenuFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='FG Color')),
                ('burgerMenuHoverBgColor', wagtail_color_panel.fields.ColorField(default='#1E1A1A', max_length=7, verbose_name='Hover BG Color')),
                ('burgerMenuHoverFgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover FG Color')),
                ('burgerMenuSelectedBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected BG Color')),
                ('burgerMenuSelectedFgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Selected FG Color')),
                ('burgerMenuAccordinExpandIcon', models.CharField(blank=True, default=None, max_length=200, null=True, verbose_name='Accordion Expand Icon')),
                ('burgerMenuAccordinCollapseIcon', models.CharField(blank=True, default=None, max_length=200, null=True, verbose_name='Accordion Collapse Icon')),
                ('burgerMenuCancelIcon', models.CharField(blank=True, max_length=200, null=True, verbose_name='Cancel Icon')),
                ('burgerMenuCancelBg', wagtail_color_panel.fields.ColorField(default='#810000', max_length=7, verbose_name='Cancel BG Color')),
                ('burgerMenuCancelFg', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Cancel FG Color')),
                ('burgerMenuFontSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Font Size')),
                ('burgerMenuIconSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Icon Size')),
                ('bottom_footerBgColor', wagtail_color_panel.fields.ColorField(default='#1D1C1C', max_length=7, verbose_name='BG Color')),
                ('bottom_footerFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='FG Color')),
                ('bottom_footerLinkFg', wagtail_color_panel.fields.ColorField(default='#CF6F00', max_length=7, verbose_name='Link FG Color')),
                ('web_bottom_footerBgColor', wagtail_color_panel.fields.ColorField(default='#1D1C1C', max_length=7, verbose_name='BG Color')),
                ('web_bottom_footerFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='FG Color')),
                ('web_bottom_footerLinkFg', wagtail_color_panel.fields.ColorField(default='#CF6F00', max_length=7, verbose_name='Link FG Color')),
                ('sidePopUpBgColor', wagtail_color_panel.fields.ColorField(default='#1D1C1C', max_length=7, verbose_name='BG Color')),
                ('sidePopUpFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='FG Color')),
                ('logoBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Color')),
                ('lofoFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Color')),
                ('web_logoBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Color')),
                ('web_logoFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Color')),
                ('bodyBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Color')),
                ('bodyFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Color')),
                ('bodyFontSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Font Size')),
                ('web_bodyBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Color')),
                ('web_bodyFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Color')),
                ('web_bodyFontSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Font Size')),
                ('headingBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Color')),
                ('headingFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Color')),
                ('web_headingBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Color')),
                ('web_headingFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Color')),
                ('subHeadingBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Color')),
                ('subHeadingFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Color')),
                ('web_subHeadingBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Color')),
                ('web_subHeadingFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Color')),
                ('iconBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Color')),
                ('iconFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Color')),
                ('iconHoverColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover Color')),
                ('iconSelectedBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected BG Color')),
                ('iconSelectedFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='Selected FG Color')),
                ('web_iconBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Color')),
                ('web_iconFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Color')),
                ('web_iconHoverColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover Color')),
                ('web_iconSelectedBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected BG Color')),
                ('web_iconSelectedFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='Selected FG Color')),
                ('popupTitleBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Color')),
                ('popupTitleFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Color')),
                ('popupContentBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected BG Color')),
                ('popupContentFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='Selected FG Color')),
                ('popupFontSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Font Size')),
                ('web_popupTitleBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Color')),
                ('web_popupTitleFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Color')),
                ('web_popupContentBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected BG Color')),
                ('web_popupContentFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='Selected FG Color')),
                ('web_popupFontSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Font Size')),
                ('adminLPBgColor', wagtail_color_panel.fields.ColorField(blank=True, max_length=7, null=True, verbose_name='BG Color')),
                ('adminLPGradientBgColor', models.TextField(blank=True, null=True, verbose_name='Fill-Effect combination')),
                ('adminLPFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Color')),
                ('adminLPHoverBgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover BG Color')),
                ('adminLPHoverFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Hover FG Color')),
                ('adminLPSelectedBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected BG Color')),
                ('adminLPSelectedFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='Selected FG Color')),
                ('adminLPFontSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Font Size')),
                ('adminLPIconSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Icon Size')),
                ('web_gridHeaderBgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Header BG Color')),
                ('web_gridHeaderFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Header FG Color')),
                ('web_gridOddBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Odd Color')),
                ('web_gridEvenBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Even Color')),
                ('web_gridOddFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Odd Color')),
                ('web_gridEvenFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Even Color')),
                ('web_gridHoverOddBgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover Odd BG Color')),
                ('web_gridHoverEvenBgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover Even BG Color')),
                ('web_gridHoverOddFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Hover Odd FG Color')),
                ('web_gridHoverEvenFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Hover Even FG Color')),
                ('web_gridSelectedOddBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected Odd BG Color')),
                ('web_gridSelectedEvenBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected Even BG Color')),
                ('web_gridSelectedOddFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='Selected Odd FG Color')),
                ('web_gridSelectedEvenFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='Selected Even FG Color')),
                ('web_gridFontSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Font Size')),
                ('web_gridIconSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Icon Size')),
                ('listOddBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Odd Color')),
                ('listEvenBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Even Color')),
                ('listOddFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Odd Color')),
                ('listEvenFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Even Color')),
                ('listHoverOddBgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover Odd BG Color')),
                ('listHoverEvenBgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover Even BG Color')),
                ('listHoverOddFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Hover Odd FG Color')),
                ('listHoverEvenFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Hover Even FG Color')),
                ('listSelectedOddBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected Odd BG Color')),
                ('listSelectedEvenBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected Even BG Color')),
                ('listSelectedOddFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='Selected Odd FG Color')),
                ('listSelectedEvenFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='Selected Even FG Color')),
                ('listFontSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Font Size')),
                ('listIconSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Icon Size')),
                ('listIconView', models.CharField(blank=True, choices=[('Top', 'Top'), ('Bottom', 'Bottom')], max_length=200, null=True, verbose_name='Icon View')),
                ('listRoundedCorner', models.FloatField(blank=True, default=5, null=True, verbose_name='Rounded Corner in px')),
                ('web_listOddBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Odd Color')),
                ('web_listEvenBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Even Color')),
                ('web_listOddFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Odd Color')),
                ('web_listEvenFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='FG Even Color')),
                ('web_listHoverOddBgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover Odd BG Color')),
                ('web_listHoverEvenBgColor', wagtail_color_panel.fields.ColorField(default='#CD3C01', max_length=7, verbose_name='Hover Even BG Color')),
                ('web_listHoverOddFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Hover Odd FG Color')),
                ('web_listHoverEvenFgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Hover even FG Color')),
                ('web_listSelectedOddBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected Odd BG Color')),
                ('web_listSelectedEvenBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='Selected Even BG Color')),
                ('web_listSelectedOddFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='Selected Odd FG Color')),
                ('web_listSelectedEvenFgColor', wagtail_color_panel.fields.ColorField(default='#0E0F0E', max_length=7, verbose_name='Selected Even FG Color')),
                ('web_listFontSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Font Size')),
                ('web_listIconSize', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], max_length=200, null=True, verbose_name='Icon Size')),
                ('web_listIconView', models.CharField(blank=True, choices=[('Top', 'Top'), ('Bottom', 'Bottom')], max_length=200, null=True, verbose_name='Icon View')),
                ('web_listRoundedCorner', models.FloatField(blank=True, default=5, null=True, verbose_name='Rounded Corner in px')),
                ('adminLPFontType', models.ManyToManyField(blank=True, related_name='adminLP_font_types', to='core.fonttype', verbose_name='Font Type')),
                ('bodyFontType', models.ManyToManyField(blank=True, to='core.fonttype', verbose_name='Font Type')),
                ('burgerMenuFontType', models.ManyToManyField(blank=True, related_name='burgerMenu_font_types', to='core.fonttype', verbose_name='Font Type')),
                ('footerFontType', models.ManyToManyField(blank=True, related_name='footer_font_types', to='core.fonttype', verbose_name='Font Type')),
                ('listFontType', models.ManyToManyField(blank=True, related_name='list_font_types', to='core.fonttype', verbose_name='Font Type')),
                ('mob_foot_menuFontType', models.ManyToManyField(blank=True, related_name='mob_foot_menu_font_types', to='core.fonttype', verbose_name='Font Type')),
                ('popupFontType', models.ManyToManyField(blank=True, related_name='popup_font_types', to='core.fonttype', verbose_name='Font Type')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.site')),
                ('topHeaderFontType', models.ManyToManyField(blank=True, related_name='topHeader_font_types', to='core.fonttype', verbose_name='Font Type')),
                ('web_bodyFontType', models.ManyToManyField(blank=True, related_name='web_body_font_types', to='core.fonttype', verbose_name='Font Type')),
                ('web_footerFontType', models.ManyToManyField(blank=True, related_name='web_footer_font_types', to='core.fonttype', verbose_name='Font Type')),
                ('web_gridFontType', models.ManyToManyField(blank=True, related_name='web_grid_font_types', to='core.fonttype', verbose_name='Font Type')),
                ('web_headerFontType', models.ManyToManyField(blank=True, related_name='web_header_font_types', to='core.fonttype', verbose_name='Font Type')),
                ('web_listFontType', models.ManyToManyField(blank=True, related_name='web_list_font_types', to='core.fonttype', verbose_name='Font Type')),
                ('web_popupFontType', models.ManyToManyField(blank=True, related_name='web_popup_font_types', to='core.fonttype', verbose_name='Font Type')),
                ('web_topHeaderFontType', models.ManyToManyField(blank=True, related_name='web_topHeader_font_types', to='core.fonttype', verbose_name='Font Type')),
            ],
            options={
                'verbose_name': 'Theme Settings',
            },
        ),
    ]
