from django.db import models
from wagtail.contrib.settings.models import (
    BaseGenericSetting,
    BaseSiteSetting,
    register_setting,
)
from wagtail.admin.panels import (
    TabbedInterface, ObjectList, FieldPanel, InlinePanel, MultiFieldPanel, FieldRowPanel, HelpPanel,
    PublishingPanel,
)
from django import forms
from wagtail.snippets.models import register_snippet
from wagtailmodelchooser import register_model_chooser

# Create your models here.
@register_setting
@register_model_chooser
class SiteLogo(BaseSiteSetting):
    logo = models.ForeignKey(
        'wagtailimages.Image',
        null=True,
        blank=True,
        on_delete=models.SET_NULL,
        related_name='+'
    )
    panels = [
        'logo'
    ]
from wagtail_color_panel.fields import ColorField

from wagtail.admin.panels import FieldPanel
from wagtail_color_panel.edit_handlers import NativeColorPanel
from web.baseSettings import FONT_SIZE_LIST

@register_snippet
class FontType(models.Model):
    font = models.CharField("Font Name", max_length=250, blank=True, null=True)
    class Meta:
        verbose_name = "Font Type"
        verbose_name_plural = "Font Types"
        ordering = ['font']  # Optional: keeps fonts alphabetically ordered

    def __str__(self):
        return self.font or "Unnamed Font"

@register_setting
class ThemeSettings(BaseSiteSetting):
    # Top Header
    topHeaderBgColor = ColorField(default='#CD3C01', verbose_name="BG Color")
    topHeaderFgColor = ColorField(default="#FFFFFF", verbose_name="FG Color")
    topHeaderHoverBgColor = ColorField(default="#FFFFFF", verbose_name="Hover BG Color")
    topHeaderHoverFgColor = ColorField(default="#CD3C01", verbose_name="Hover FG Color")
    topHeaderSelectedBgColor = ColorField(default='#FFFFFF', verbose_name="Selected BG Color")
    topHeaderSelectedFgColor = ColorField(default="#CD3C01", verbose_name="Selected FG Color")
    topHeaderFontType = models.ManyToManyField(FontType, blank=True, verbose_name="Font Type",related_name="topHeader_font_types")
    topHeaderFontSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Font Size")
    topHeaderIconSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Icon Size")
    
    web_topHeaderBgColor = ColorField(default='#CD3C01', verbose_name="BG Color")
    web_topHeaderFgColor = ColorField(default="#FFFFFF", verbose_name="FG Color")
    web_topHeaderHoverBgColor = ColorField(default="#FFFFFF", verbose_name="Hover BG Color")
    web_topHeaderHoverFgColor = ColorField(default="#CD3C01", verbose_name="Hover FG Color")
    web_topHeaderSelectedBgColor = ColorField(default='#FFFFFF', verbose_name="Selected BG Color")
    web_topHeaderSelectedFgColor = ColorField(default="#CD3C01", verbose_name="Selected FG Color")
    web_topHeaderFontType = models.ManyToManyField(FontType, blank=True, verbose_name="Font Type",related_name="web_topHeader_font_types")
    web_topHeaderFontSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Font Size")
    web_topHeaderIconSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Icon Size")
    
    # Header Menu (Web)
    web_headerBgColor = ColorField(blank=True,null=True,verbose_name="BG Color")
    web_headerGradientBgColor = models.TextField(blank=True,null=True,verbose_name="Fill-Effect combination")
    web_headerFgColor = ColorField(default="#FFFFFF", verbose_name="FG Color")
    web_headerHoverBgColor = ColorField(default="#FFFFFF", verbose_name="Hover BG Color")
    web_headerHoverFgColor = ColorField(default="#CD3C01", verbose_name="Hover FG Color")
    web_headerSelectedBgColor = ColorField(default='#FFFFFF', verbose_name="Selected BG Color")
    web_headerSelectedFgColor = ColorField(default="#CD3C01", verbose_name="Selected FG Color")
    web_headerSelectedPosition=models.CharField(max_length=200,blank=True,null=True,default=None,choices=[(None,'None'),('Top','Top'),('Bottom','Bottom')])
    web_headerFontType = models.ManyToManyField(FontType, blank=True, verbose_name="Font Type",related_name="web_header_font_types")
    web_headerFontSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Font Size")
    web_headerIconSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Icon Size")
    
    # Mobile Header
    mobile_headerBgColor = ColorField(blank=True,null=True,verbose_name="BG Color")
    mobile_headerGradientBgColor = models.TextField(blank=True,null=True,verbose_name="Fill-Effect combination")
    mobile_headerFgColor = ColorField(default="#FFFFFF", verbose_name="FG Color")
    mobile_headerLogoSize = models.CharField(max_length=200,blank=True,null=True,choices=[(None,'None'),('Big','Big'),('Medium','Medium'),('Small','Small')],verbose_name="Logo Size")
    mobile_headerMenuIcon = models.CharField(max_length=200,blank=True,null=True,verbose_name="Menu Icon")
    mobile_headerCancelIcon = models.CharField(max_length=200,blank=True,null=True,verbose_name="Cancel Icon")
    mobile_headerCancelBg = ColorField(default="#810000",verbose_name="Cancel BG Color")
    mobile_headerCancelFg = ColorField(default="#FFFFFF",verbose_name="Cancel FG Color")
    
    # Footer
    footerBgColor = ColorField(blank=True,null=True,verbose_name="BG Color")
    footerGradientBgColor = models.TextField(blank=True,null=True,verbose_name="Fill-Effect combination")
    footerFgColor = ColorField(default="#FFFFFF", verbose_name="FG Color")
    footerHoverBgColor = ColorField(default="#FFFFFF", verbose_name="Hover BG Color")
    footerHoverFgColor = ColorField(default="#CD3C01", verbose_name="Hover FG Color")
    footerSelectedBgColor = ColorField(default='#FFFFFF', verbose_name="Selected BG Color")
    footerSelectedFgColor = ColorField(default="#CD3C01", verbose_name="Selected FG Color")
    footerFontType = models.ManyToManyField(FontType, blank=True, verbose_name="Font Type",related_name="footer_font_types")
    footerFontSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Font Size")
    footerIconSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Icon Size")
    footerAccordinExpandIcon=models.CharField(max_length=200,blank=True,null=True,default=None,verbose_name="Accordion Expand Icon")
    footerAccordinCollapseIcon=models.CharField(max_length=200,blank=True,null=True,default=None,verbose_name="Accordion Collapse Icon")
    
    web_footerBgColor = ColorField(blank=True,null=True,verbose_name="BG Color")
    web_footerGradientBgColor = models.TextField(blank=True,null=True,verbose_name="Fill-Effect combination")
    web_footerFgColor = ColorField(default="#FFFFFF", verbose_name="FG Color")
    web_footerHoverBgColor = ColorField(default="#FFFFFF", verbose_name="Hover BG Color")
    web_footerHoverFgColor = ColorField(default="#CD3C01", verbose_name="Hover FG Color")
    web_footerSelectedBgColor = ColorField(default='#FFFFFF', verbose_name="Selected BG Color")
    web_footerSelectedFgColor = ColorField(default="#CD3C01", verbose_name="Selected FG Color")
    web_footerFontType = models.ManyToManyField(FontType, blank=True, verbose_name="Font Type",related_name="web_footer_font_types")
    web_footerFontSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Font Size")
    web_footerIconSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Icon Size")
    
    # Mobile Footer Menu
    mob_foot_menuBgColor = ColorField(default="#CD3C01",verbose_name="BG Color")
    mob_foot_menuFgColor = ColorField(default="#FFFFFF", verbose_name="FG Color")
    mob_foot_menuHoverBgColor = ColorField(default="#1E1A1A", verbose_name="Hover BG Color")
    mob_foot_menuHoverFgColor = ColorField(default="#CD3C01", verbose_name="Hover FG Color")
    mob_foot_menuSelectedBgColor = ColorField(default='#FFFFFF', verbose_name="Selected BG Color")
    mob_foot_menuSelectedFgColor = ColorField(default="#CD3C01", verbose_name="Selected FG Color")
    mob_foot_menuSelectedPosition=models.CharField(max_length=200,blank=True,null=True,default=None,choices=[(None,'None'),('Top','Top'),('Bottom','Bottom')])
    mob_foot_menuFontType = models.ManyToManyField(FontType, blank=True, verbose_name="Font Type",related_name="mob_foot_menu_font_types")
    mob_foot_menuFontSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Font Size")
    mob_foot_menuIconSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Icon Size")
    mob_foot_menuMenuIcon = models.CharField(max_length=200,blank=True,null=True,verbose_name="Menu Icon")
    mob_foot_menuCancelIcon = models.CharField(max_length=200,blank=True,null=True,verbose_name="Cancel Icon")
    mob_foot_menuCancelBg = ColorField(default="#810000",verbose_name="Cancel BG Color")
    mob_foot_menuCancelFg = ColorField(default="#FFFFFF",verbose_name="Cancel FG Color")
    
    # Burger Menu
    burgerMenuBgColor = ColorField(blank=True,null=True,verbose_name="BG Color")
    burgerMenuGradientBgColor = models.TextField(blank=True,null=True,verbose_name="Fill-Effect combination")
    burgerMenuFgColor = ColorField(default="#FFFFFF", verbose_name="FG Color")
    burgerMenuHoverBgColor = ColorField(default="#1E1A1A", verbose_name="Hover BG Color")
    burgerMenuHoverFgColor = ColorField(default="#CD3C01", verbose_name="Hover FG Color")
    burgerMenuSelectedBgColor = ColorField(default='#FFFFFF', verbose_name="Selected BG Color")
    burgerMenuSelectedFgColor = ColorField(default="#CD3C01", verbose_name="Selected FG Color")
    burgerMenuAccordinExpandIcon=models.CharField(max_length=200,blank=True,null=True,default=None,verbose_name="Accordion Expand Icon")
    burgerMenuAccordinCollapseIcon=models.CharField(max_length=200,blank=True,null=True,default=None,verbose_name="Accordion Collapse Icon")
    burgerMenuCancelIcon = models.CharField(max_length=200,blank=True,null=True,verbose_name="Cancel Icon")
    burgerMenuCancelBg = ColorField(default="#810000",verbose_name="Cancel BG Color")
    burgerMenuCancelFg = ColorField(default="#FFFFFF",verbose_name="Cancel FG Color")
    burgerMenuFontType = models.ManyToManyField(FontType, blank=True, verbose_name="Font Type",related_name="burgerMenu_font_types")
    burgerMenuFontSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Font Size")
    burgerMenuIconSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Icon Size")
    
    # Bottom Footer
    bottom_footerBgColor = ColorField(default="#1D1C1C",verbose_name="BG Color")
    bottom_footerFgColor = ColorField(default="#FFFFFF", verbose_name="FG Color")
    bottom_footerLinkFg = ColorField(default="#CF6F00",verbose_name="Link FG Color")
    
    web_bottom_footerBgColor = ColorField(default="#1D1C1C",verbose_name="BG Color")
    web_bottom_footerFgColor = ColorField(default="#FFFFFF", verbose_name="FG Color")
    web_bottom_footerLinkFg = ColorField(default="#CF6F00",verbose_name="Link FG Color")
    
    # Side PopUp
    sidePopUpBgColor = ColorField(default="#1D1C1C",verbose_name="BG Color")
    sidePopUpFgColor = ColorField(default="#FFFFFF", verbose_name="FG Color")
    
    # Logo
    logoBgColor = ColorField(default='#FFFFFF', verbose_name="BG Color")
    lofoFgColor = ColorField(default="#0E0F0E", verbose_name="FG Color")
    
    web_logoBgColor = ColorField(default='#FFFFFF', verbose_name="BG Color")
    web_logoFgColor = ColorField(default="#0E0F0E", verbose_name="FG Color")
    
    
    # PageBody
    bodyBgColor = ColorField(default='#FFFFFF', verbose_name="BG Color")
    bodyFgColor = ColorField(default="#0E0F0E", verbose_name="FG Color")
    bodyFontType = models.ManyToManyField(FontType, blank=True, verbose_name="Font Type")
    bodyFontSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Font Size")
    
    web_bodyBgColor = ColorField(default='#FFFFFF', verbose_name="BG Color")
    web_bodyFgColor = ColorField(default="#0E0F0E", verbose_name="FG Color")
    web_bodyFontType = models.ManyToManyField(FontType, blank=True, verbose_name="Font Type",related_name="web_body_font_types")
    web_bodyFontSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Font Size")
    
    # Heading
    headingBgColor = ColorField(default='#FFFFFF', verbose_name="BG Color")
    headingFgColor = ColorField(default="#0E0F0E", verbose_name="FG Color")
    
    web_headingBgColor = ColorField(default='#FFFFFF', verbose_name="BG Color")
    web_headingFgColor = ColorField(default="#0E0F0E", verbose_name="FG Color")
    # Sub-Heading
    subHeadingBgColor = ColorField(default='#FFFFFF', verbose_name="BG Color")
    subHeadingFgColor = ColorField(default="#0E0F0E", verbose_name="FG Color")
    
    web_subHeadingBgColor = ColorField(default='#FFFFFF', verbose_name="BG Color")
    web_subHeadingFgColor = ColorField(default="#0E0F0E", verbose_name="FG Color")
    
    # Icon
    iconBgColor = ColorField(default='#FFFFFF', verbose_name="BG Color")
    iconFgColor = ColorField(default="#0E0F0E", verbose_name="FG Color")
    iconHoverColor = ColorField(default="#CD3C01", verbose_name="Hover Color")
    iconSelectedBgColor = ColorField(default='#FFFFFF', verbose_name="Selected BG Color")
    iconSelectedFgColor = ColorField(default="#0E0F0E", verbose_name="Selected FG Color")
    
    web_iconBgColor = ColorField(default='#FFFFFF', verbose_name="BG Color")
    web_iconFgColor = ColorField(default="#0E0F0E", verbose_name="FG Color")
    web_iconHoverColor = ColorField(default="#CD3C01", verbose_name="Hover Color")
    web_iconSelectedBgColor = ColorField(default='#FFFFFF', verbose_name="Selected BG Color")
    web_iconSelectedFgColor = ColorField(default="#0E0F0E", verbose_name="Selected FG Color")
    
    # Popup
    popupTitleBgColor = ColorField(default='#FFFFFF', verbose_name="BG Color")
    popupTitleFgColor = ColorField(default="#0E0F0E", verbose_name="FG Color")
    popupContentBgColor = ColorField(default='#FFFFFF', verbose_name="Selected BG Color")
    popupContentFgColor = ColorField(default="#0E0F0E", verbose_name="Selected FG Color")
    popupFontType = models.ManyToManyField(FontType, blank=True, verbose_name="Font Type",related_name="popup_font_types")
    popupFontSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Font Size")
    
    web_popupTitleBgColor = ColorField(default='#FFFFFF', verbose_name="BG Color")
    web_popupTitleFgColor = ColorField(default="#0E0F0E", verbose_name="FG Color")
    web_popupContentBgColor = ColorField(default='#FFFFFF', verbose_name="Selected BG Color")
    web_popupContentFgColor = ColorField(default="#0E0F0E", verbose_name="Selected FG Color")
    web_popupFontType = models.ManyToManyField(FontType, blank=True, verbose_name="Font Type",related_name="web_popup_font_types")
    web_popupFontSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Font Size")
    
    # Admin Left Panel
    adminLPBgColor = ColorField(blank=True,null=True, verbose_name="BG Color")
    adminLPGradientBgColor = models.TextField(blank=True,null=True,verbose_name="Fill-Effect combination")
    adminLPFgColor = ColorField(default="#0E0F0E", verbose_name="FG Color")
    adminLPHoverBgColor = ColorField(default="#CD3C01", verbose_name="Hover BG Color")
    adminLPHoverFgColor = ColorField(default="#FFFFFF", verbose_name="Hover FG Color")
    adminLPSelectedBgColor = ColorField(default='#FFFFFF', verbose_name="Selected BG Color")
    adminLPSelectedFgColor = ColorField(default="#0E0F0E", verbose_name="Selected FG Color")
    adminLPFontType = models.ManyToManyField(FontType, blank=True, verbose_name="Font Type",related_name="adminLP_font_types")
    adminLPFontSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Font Size")
    adminLPIconSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Icon Size")
    
    # Grid
    web_gridHeaderBgColor = ColorField(default='#CD3C01', verbose_name="Header BG Color")
    web_gridHeaderFgColor = ColorField(default="#FFFFFF", verbose_name="Header FG Color")
    
    web_gridOddBgColor = ColorField(default='#FFFFFF', verbose_name="BG Odd Color")
    web_gridEvenBgColor = ColorField(default='#FFFFFF', verbose_name="BG Even Color")
    
    web_gridOddFgColor = ColorField(default="#0E0F0E", verbose_name="FG Odd Color")
    web_gridEvenFgColor = ColorField(default="#0E0F0E", verbose_name="FG Even Color")
    
    web_gridHoverOddBgColor = ColorField(default="#CD3C01", verbose_name="Hover Odd BG Color")
    web_gridHoverEvenBgColor = ColorField(default="#CD3C01", verbose_name="Hover Even BG Color")
    
    web_gridHoverOddFgColor = ColorField(default="#FFFFFF", verbose_name="Hover Odd FG Color")
    web_gridHoverEvenFgColor = ColorField(default="#FFFFFF", verbose_name="Hover Even FG Color")
    
    web_gridSelectedOddBgColor = ColorField(default='#FFFFFF', verbose_name="Selected Odd BG Color")
    web_gridSelectedEvenBgColor = ColorField(default='#FFFFFF', verbose_name="Selected Even BG Color")
    web_gridSelectedOddFgColor = ColorField(default="#0E0F0E", verbose_name="Selected Odd FG Color")
    web_gridSelectedEvenFgColor = ColorField(default="#0E0F0E", verbose_name="Selected Even FG Color")
    web_gridFontType = models.ManyToManyField(FontType, blank=True, verbose_name="Font Type",related_name="web_grid_font_types")
    web_gridFontSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Font Size")
    web_gridIconSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Icon Size")
    
    # List
    listOddBgColor = ColorField(default='#FFFFFF', verbose_name="BG Odd Color")
    listEvenBgColor = ColorField(default='#FFFFFF', verbose_name="BG Even Color")
    listOddFgColor = ColorField(default="#0E0F0E", verbose_name="FG Odd Color")
    listEvenFgColor = ColorField(default="#0E0F0E", verbose_name="FG Even Color")
    listHoverOddBgColor = ColorField(default="#CD3C01", verbose_name="Hover Odd BG Color")
    listHoverEvenBgColor = ColorField(default="#CD3C01", verbose_name="Hover Even BG Color")
    listHoverOddFgColor = ColorField(default="#FFFFFF", verbose_name="Hover Odd FG Color")
    listHoverEvenFgColor = ColorField(default="#FFFFFF", verbose_name="Hover Even FG Color")
    listSelectedOddBgColor = ColorField(default='#FFFFFF', verbose_name="Selected Odd BG Color")
    listSelectedEvenBgColor = ColorField(default='#FFFFFF', verbose_name="Selected Even BG Color")
    listSelectedOddFgColor = ColorField(default="#0E0F0E", verbose_name="Selected Odd FG Color")
    listSelectedEvenFgColor = ColorField(default="#0E0F0E", verbose_name="Selected Even FG Color")
    listFontType = models.ManyToManyField(FontType, blank=True, verbose_name="Font Type",related_name="list_font_types")
    listFontSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Font Size")
    listIconSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Icon Size")
    listIconView = models.CharField(max_length=200,blank=True,null=True, choices=[('Top','Top'),('Bottom','Bottom')], verbose_name="Icon View")
    listRoundedCorner = models.FloatField(blank=True,null=True, default=5, verbose_name="Rounded Corner in pixel")
    
    web_listOddBgColor = ColorField(default='#FFFFFF', verbose_name="BG Odd Color")
    web_listEvenBgColor = ColorField(default='#FFFFFF', verbose_name="BG Even Color")
    web_listOddFgColor = ColorField(default="#0E0F0E", verbose_name="FG Odd Color")
    web_listEvenFgColor = ColorField(default="#0E0F0E", verbose_name="FG Even Color")
    web_listHoverOddBgColor = ColorField(default="#CD3C01", verbose_name="Hover Odd BG Color")
    web_listHoverEvenBgColor = ColorField(default="#CD3C01", verbose_name="Hover Even BG Color")
    web_listHoverOddFgColor = ColorField(default="#FFFFFF", verbose_name="Hover Odd FG Color")
    web_listHoverEvenFgColor = ColorField(default="#FFFFFF", verbose_name="Hover even FG Color")
    web_listSelectedOddBgColor = ColorField(default='#FFFFFF', verbose_name="Selected Odd BG Color")
    web_listSelectedEvenBgColor = ColorField(default='#FFFFFF', verbose_name="Selected Even BG Color")
    web_listSelectedOddFgColor = ColorField(default="#0E0F0E", verbose_name="Selected Odd FG Color")
    web_listSelectedEvenFgColor = ColorField(default="#0E0F0E", verbose_name="Selected Even FG Color")
    web_listFontType = models.ManyToManyField(FontType, blank=True, verbose_name="Font Type",related_name="web_list_font_types")
    web_listFontSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Font Size")
    web_listIconSize = models.CharField(max_length=200,blank=True,null=True, choices=FONT_SIZE_LIST, verbose_name="Icon Size")
    web_listIconView = models.CharField(max_length=200,blank=True,null=True, choices=[('Top','Top'),('Bottom','Bottom')], verbose_name="Icon View")
    web_listRoundedCorner = models.FloatField(blank=True,null=True, default=5, verbose_name="Rounded Corner in pixel")
    
    
    
    # primary_bgColor = ColorField(default='#CD3C01', help_text="Primary BG Color")
    # secondary_bgColor = ColorField(default='#FFFFFF', help_text="Secondary BG Color")
    # primary_color = ColorField(default='#FFFFFF', help_text="Primary FG Color")
    # secondary_color = ColorField(default="#0E0F0E", help_text="Secondary FG Color")
    # optional = ColorField(default='#71726D', help_text="Optional color")

    mobile_panels = [
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('topHeaderBgColor'),
                NativeColorPanel('topHeaderFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('topHeaderHoverBgColor'),
                NativeColorPanel('topHeaderHoverFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('topHeaderSelectedBgColor'),
                NativeColorPanel('topHeaderSelectedFgColor'),
            ]),
            FieldRowPanel([
                FieldPanel('topHeaderFontType',widget=forms.CheckboxSelectMultiple()),
                'topHeaderFontSize','topHeaderIconSize'
            ])
            
        ],heading="Top Header"),
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('mobile_headerBgColor'),
                NativeColorPanel('mobile_headerFgColor'),
            ]),'mobile_headerGradientBgColor',
            FieldRowPanel([
                'mobile_headerLogoSize',
                'mobile_headerMenuIcon',
                'mobile_headerCancelIcon',
            ]),
            FieldRowPanel([
                NativeColorPanel('mobile_headerCancelBg'),
                NativeColorPanel('mobile_headerCancelFg')
            ])
            
        ],heading="Mobile Header"),
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('footerBgColor'),
                NativeColorPanel('footerFgColor'),
            ]),
            'footerGradientBgColor',
            FieldRowPanel([
                NativeColorPanel('footerHoverBgColor'),
                NativeColorPanel('footerHoverFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('footerSelectedBgColor'),
                NativeColorPanel('footerSelectedFgColor'),
            ]),
            FieldRowPanel([
                FieldPanel('footerFontType',widget=forms.CheckboxSelectMultiple()),
                'footerFontSize','footerIconSize'
            ]),
            FieldRowPanel([
                'footerAccordinExpandIcon',
                'footerAccordinCollapseIcon'
            ])
            
        ],heading="Footer"),
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('mob_foot_menuBgColor'),
                NativeColorPanel('mob_foot_menuFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('mob_foot_menuHoverBgColor'),
                NativeColorPanel('mob_foot_menuHoverFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('mob_foot_menuSelectedBgColor'),
                NativeColorPanel('mob_foot_menuSelectedFgColor'),
            ]),
            FieldRowPanel([
                'mob_foot_menuSelectedPosition',
                FieldPanel('mob_foot_menuFontType',widget=forms.CheckboxSelectMultiple()),
                'mob_foot_menuFontSize'
            ]),
            FieldRowPanel([
                'mob_foot_menuIconSize',
                'mob_foot_menuMenuIcon',
                'mob_foot_menuCancelIcon'
            ]),
            FieldRowPanel([
                NativeColorPanel('mob_foot_menuCancelBg'),
                NativeColorPanel('mob_foot_menuCancelFg'),
            ]),
            
        ],heading="Footer Menu"),
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('burgerMenuBgColor'),
                NativeColorPanel('burgerMenuFgColor'),
            ]),
            'burgerMenuGradientBgColor',
            FieldRowPanel([
                NativeColorPanel('burgerMenuHoverBgColor'),
                NativeColorPanel('burgerMenuHoverFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('burgerMenuSelectedBgColor'),
                NativeColorPanel('burgerMenuSelectedFgColor'),
            ]),
            FieldRowPanel([
                'burgerMenuAccordinExpandIcon',
                'burgerMenuAccordinCollapseIcon'
            ]),
            FieldRowPanel([
                FieldPanel('burgerMenuFontType',widget=forms.CheckboxSelectMultiple()),
                'burgerMenuFontSize',
                'burgerMenuIconSize'
            ]),
            FieldRowPanel([
                'mob_foot_menuIconSize',
                'mob_foot_menuMenuIcon',
                'mob_foot_menuCancelIcon'
            ]),
            FieldRowPanel([
                'burgerMenuCancelIcon',
                NativeColorPanel('burgerMenuCancelBg'),
                NativeColorPanel('burgerMenuCancelFg'),
            ]),
            
        ],heading="Burger Menu"),
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('bottom_footerBgColor'),
                NativeColorPanel('bottom_footerFgColor'),
                NativeColorPanel('bottom_footerLinkFg'),
            ]),
          
        ],heading="Bottom Footer"),
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('sidePopUpBgColor'),
                NativeColorPanel('sidePopUpFgColor'),
            ]),
        ],heading="Side PopUp"),
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('logoBgColor'),
                NativeColorPanel('lofoFgColor'),
            ]),
        ],heading="Logo"),
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('bodyBgColor'),
                NativeColorPanel('bodyFgColor'),
            ]),
            FieldRowPanel([
                FieldPanel('bodyFontType',widget=forms.CheckboxSelectMultiple()),
                'bodyFontSize',
            ])
            
        ],heading="Page Body"),
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('headingBgColor'),
                NativeColorPanel('headingFgColor'),
            ])
        ],heading="Heading"),
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('subHeadingBgColor'),
                NativeColorPanel('subHeadingFgColor'),
            ])
        ],heading="Sub-Heading"),
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('iconBgColor'),
                NativeColorPanel('iconFgColor'),
                NativeColorPanel('iconHoverColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('iconSelectedBgColor'),
                NativeColorPanel('iconSelectedFgColor'),
            ])
        ],heading="Icon"),
        
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('popupTitleBgColor'),
                NativeColorPanel('popupTitleFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('popupContentBgColor'),
                NativeColorPanel('popupContentFgColor'),
            ]),
            FieldRowPanel([
                FieldPanel('popupFontType',widget=forms.CheckboxSelectMultiple()),
                'popupFontSize'
            ])
        ],heading="Popup"),
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('listOddBgColor'),
                NativeColorPanel('listOddFgColor'),
                NativeColorPanel('listEvenBgColor'),
                NativeColorPanel('listEvenFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('listHoverOddBgColor'),
                NativeColorPanel('listHoverEvenFgColor'),
                NativeColorPanel('listHoverOddBgColor'),
                NativeColorPanel('listHoverEvenFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('listSelectedOddBgColor'),
                NativeColorPanel('listSelectedEvenFgColor'),
                NativeColorPanel('listSelectedOddBgColor'),
                NativeColorPanel('listSelectedEvenFgColor'),
            ]),
            FieldRowPanel([
                FieldPanel('listFontType',widget=forms.CheckboxSelectMultiple()),
                'listFontSize'
            ]),
            FieldRowPanel([
                'listIconSize',
                'listIconView','listRoundedCorner'
            ])
        ],heading="List"),
        ]

    
    web_panels = [
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('web_topHeaderBgColor'),
                NativeColorPanel('web_topHeaderFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('web_topHeaderHoverBgColor'),
                NativeColorPanel('web_topHeaderHoverFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('web_topHeaderSelectedBgColor'),
                NativeColorPanel('web_topHeaderSelectedFgColor'),
            ]),
            FieldRowPanel([
                FieldPanel('web_topHeaderFontType',widget=forms.CheckboxSelectMultiple()),
                'web_topHeaderFontSize','web_topHeaderIconSize'
            ])
            
        ],heading="Top Header"),
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('web_headerBgColor'),
                NativeColorPanel('web_headerFgColor'),
            ]),'web_headerGradientBgColor',
            FieldRowPanel([
                NativeColorPanel('web_headerHoverBgColor'),
                NativeColorPanel('web_headerHoverFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('web_headerSelectedBgColor'),
                NativeColorPanel('web_headerSelectedFgColor'),
            ]),
            FieldRowPanel([
                # 'web_headerSelectedPosition',
                FieldPanel('web_headerFontType',widget=forms.CheckboxSelectMultiple()),
                'web_headerFontSize',
                'web_headerIconSize'
            ]),
            
            
        ],heading="Header Menu"),
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('web_footerBgColor'),
                NativeColorPanel('web_footerFgColor'),
            ]),
            'web_footerGradientBgColor',
            FieldRowPanel([
                NativeColorPanel('web_footerHoverBgColor'),
                NativeColorPanel('web_footerHoverFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('web_footerSelectedBgColor'),
                NativeColorPanel('web_footerSelectedFgColor'),
            ]),
            FieldRowPanel([
                FieldPanel('web_footerFontType',widget=forms.CheckboxSelectMultiple()),
                'web_footerFontSize','web_footerIconSize'
            ])
            
        ],heading="Footer"),
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('web_bottom_footerBgColor'),
                NativeColorPanel('web_bottom_footerFgColor'),
                NativeColorPanel('web_bottom_footerLinkFg'),
            ]),
          
        ],heading="Bottom Footer"),
        
       
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('web_logoBgColor'),
                NativeColorPanel('web_logoFgColor'),
            ]),
        ],heading="Logo"),
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('web_bodyBgColor'),
                NativeColorPanel('web_bodyFgColor'),
            ]),
            FieldRowPanel([
                FieldPanel('web_bodyFontType',widget=forms.CheckboxSelectMultiple()),
                'web_bodyFontSize',
            ])
            
        ],heading="Page Body"),
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('web_headingBgColor'),
                NativeColorPanel('web_headingFgColor'),
            ])
        ],heading="Heading"),
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('web_subHeadingBgColor'),
                NativeColorPanel('web_subHeadingFgColor'),
            ])
        ],heading="Sub-Heading"),
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('web_iconBgColor'),
                NativeColorPanel('web_iconFgColor'),
                NativeColorPanel('web_iconHoverColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('web_iconSelectedBgColor'),
                NativeColorPanel('web_iconSelectedFgColor'),
            ])
        ],heading="Icon"),
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('web_popupTitleBgColor'),
                NativeColorPanel('web_popupTitleFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('web_popupContentBgColor'),
                NativeColorPanel('web_popupContentFgColor'),
            ]),
            FieldRowPanel([
                FieldPanel('web_popupFontType',widget=forms.CheckboxSelectMultiple()),
                'web_popupFontSize'
            ])
        ],heading="Popup"),
       ]
    
    admin_panels=[
        
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('adminLPBgColor'),
                NativeColorPanel('adminLPFgColor'),
            ]),
            'adminLPGradientBgColor',
            FieldRowPanel([
                NativeColorPanel('adminLPHoverBgColor'),
                NativeColorPanel('adminLPHoverFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('adminLPSelectedBgColor'),
                NativeColorPanel('adminLPSelectedFgColor'),
            ]),
            FieldRowPanel([
                FieldPanel('adminLPFontType',widget=forms.CheckboxSelectMultiple()),
                'adminLPFontSize','adminLPIconSize'
            ])
        ],heading="Admin Left Panel"),
        
        MultiFieldPanel([
            
            FieldRowPanel([
                NativeColorPanel('web_gridHeaderBgColor'),
                NativeColorPanel('web_gridHeaderFgColor'),
            ],heading="Header"),
            FieldRowPanel([
                NativeColorPanel('web_gridOddBgColor'),
                NativeColorPanel('web_gridOddFgColor'),
                NativeColorPanel('web_gridEvenBgColor'),
                NativeColorPanel('web_gridEvenFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('web_gridHoverOddBgColor'),
                NativeColorPanel('web_gridHoverOddFgColor'),
                NativeColorPanel('web_gridHoverEvenBgColor'),
                NativeColorPanel('web_gridHoverEvenFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('web_gridSelectedOddBgColor'),
                NativeColorPanel('web_gridSelectedOddFgColor'),
                NativeColorPanel('web_gridSelectedEvenBgColor'),
                NativeColorPanel('web_gridSelectedEvenFgColor'),
            ]),
            FieldRowPanel([
                FieldPanel('web_gridFontType',widget=forms.CheckboxSelectMultiple()),
                'web_gridFontSize','web_gridIconSize'
            ])
        ],heading="Grid"),
        MultiFieldPanel([
            FieldRowPanel([
                NativeColorPanel('web_listOddBgColor'),
                NativeColorPanel('web_listOddFgColor'),
                NativeColorPanel('web_listEvenBgColor'),
                NativeColorPanel('web_listEvenFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('web_listHoverOddBgColor'),
                NativeColorPanel('web_listHoverOddFgColor'),
                NativeColorPanel('web_listHoverEvenBgColor'),
                NativeColorPanel('web_listHoverEvenFgColor'),
            ]),
            FieldRowPanel([
                NativeColorPanel('web_listSelectedOddBgColor'),
                NativeColorPanel('web_listSelectedOddFgColor'),
                NativeColorPanel('web_listSelectedEvenBgColor'),
                NativeColorPanel('web_listSelectedEvenFgColor'),
            ]),
            FieldRowPanel([
                FieldPanel('web_listFontType',widget=forms.CheckboxSelectMultiple()),
                'web_listFontSize'
            ]),
            FieldRowPanel([
                'web_listIconSize',
                'web_listIconView','web_listRoundedCorner'
            ])
        ],heading="List"),
        
                ]

    
    edit_handler = TabbedInterface([
        ObjectList(mobile_panels, heading='Mobile'),
        ObjectList(web_panels, heading='Web'),
        ObjectList(admin_panels, heading='Admin'),
    ])
    class Meta:
        verbose_name = 'Theme Settings'
        
        
# @register_snippet
class IdentityType(models.Model):
    type = models.CharField(max_length=150,verbose_name="Entry Name") # AAdhar,PAN,Passport,etc...
    docName = models.CharField(max_length=150,verbose_name="Document Name") # AAdhar,PAN,Passport,etc...
    typeFormat = models.CharField(max_length=150,blank=True,null=True) # AAdhar,PAN,Passport,etc...
    typeLength = models.PositiveIntegerField(blank=True,null=True) # AAdhar,PAN,Passport,etc...
    placeholder = models.CharField(max_length=200,blank=True,null=True) 
    message = models.CharField(max_length=200,blank=True,null=True) 
    progress = models.BooleanField(blank=True,null=True) 
    def __str__(self):
        return f"{self.type}"
    panels=[
        MultiFieldPanel([
            FieldRowPanel([
                'type','docName'
            ]),
            FieldRowPanel([
                'typeFormat','typeLength',
                FieldPanel('progress',widget=forms.CheckboxInput())
            ]),
            FieldRowPanel([
            'placeholder','message'
            ]),
        ])
        
    ]


class CompanyHoliday(models.Model):
    """
    Defines company-specific holidays, managed via Wagtail Snippets.
    """
    date = models.DateField(unique=True)
    name = models.CharField(max_length=100)
    is_national_holiday = models.BooleanField(default=False)


    panels = [
        'date',
        'name',
        'is_national_holiday',
    ]


    class Meta:
        verbose_name = "Company Holiday"
        verbose_name_plural = "Company Holidays"
        ordering = ['date']


    def __str__(self):
        return f"{self.name} ({self.date})"


