from rest_framework import serializers

from .models import CompanyHoliday,SiteLogo,IdentityType
from wagtail.images.models import Image

# yourapp/api.py
from .models import ThemeSettings,FontType

class FontTypeSerializer(serializers.ModelSerializer):
    class Meta:
        model = FontType
        fields = '__all__'


class ThemeSettingsSerializer(serializers.ModelSerializer):
    # type = serializers.SerializerMethodField()

    class Meta:
        model=ThemeSettings
        fields="__all__"
        depth=2
    #     extra_kwargs = {
    #         'url': {'view_name': 'themesettings-detail'}
    #     }
    # def get_type(self, obj):
    #     return "themeSettings"  # or whatever static string identifier you want
    
class ImageSerializer(serializers.ModelSerializer):
    # Define the fields you want to expose (e.g., the image URL)
    file = serializers.SerializerMethodField()

    class Meta:
        model = Image
        fields = ['id', 'title', 'file']

    def get_file(self, obj):
        # The file field in Wagtail's Image model is an ImageField
        # You can get the URL of the image using `.url`
        return obj.file.url

class SiteLogoSerializer(serializers.ModelSerializer):
    logo=ImageSerializer()
    class Meta:
        model = SiteLogo
        fields = ['id', 'logo']  # Include 'id' and 'logo' fields

class CompanyHolidaySerializer(serializers.ModelSerializer):
    class Meta:
        model = CompanyHoliday
        fields = '__all__'


class IdentityTypeSerializer(serializers.ModelSerializer):
    class Meta:
        model = IdentityType
        fields = '__all__'



