# signals.py
from django.db.models.signals import post_save
from django.dispatch import receiver
from .models import ThemeSettings
from asgiref.sync import async_to_sync
from channels.layers import get_channel_layer
from .serializers import ThemeSettingsSerializer

@receiver(post_save, sender=ThemeSettings)
def broadcast_theme_update(sender, instance, **kwargs):
    channel_layer = get_channel_layer()
    data = ThemeSettingsSerializer(instance).data
    async_to_sync(channel_layer.group_send)(
        "theme_updates",
        {
            "type": "send_theme_update",
            "data": data,
        }
    )
