from django.shortcuts import render

# Create your views here.
from django.contrib.auth import get_user_model
CustomUser = get_user_model()
from django.utils import timezone

from rest_framework import viewsets, status
from rest_framework.decorators import action
from rest_framework.permissions import IsAuthenticated, IsAdminUser, DjangoModelPermissions
from django.db.models import Sum, F
from django.shortcuts import get_object_or_404
from rest_framework.pagination import PageNumberPagination


from wagtail.api.v2.views import PagesAPIViewSet, BaseAPIViewSet


from rest_framework.decorators import api_view
from rest_framework.response import Response

from datetime import datetime
from django.http import HttpResponse
from wagtail_favicon.models import FaviconSettings
# from wagtail_favicon.models import Favicon
# base_favicon_image
from .serializers import *
from django.core.cache import cache
from django.db.models import Prefetch
from rest_framework.views import APIView
from rest_framework import permissions

from .serializers import *

# yourapp/api.py
from wagtail.api.v2.views import BaseAPIViewSet
from .models import ThemeSettings

    # body_fields = ['primary_bgColor', 'secondary_bgColor', 'primary_color', 'secondary_color','optional']
    # listing_default_fields = body_fields

# views.py
from .serializers import ThemeSettingsSerializer

class ThemeSettingsViewSet(viewsets.ModelViewSet):
    queryset = ThemeSettings.objects.all()
    serializer_class = ThemeSettingsSerializer

# yourapp/wagtail_hooks.py


class CompanyHolidayViewSet(viewsets.ModelViewSet):
    queryset = CompanyHoliday.objects.all()
    serializer_class = CompanyHolidaySerializer
    permission_classes = [IsAdminUser | DjangoModelPermissions] # Only admin can manage holidays


  
    
class SiteLogoViewSet(viewsets.ModelViewSet):
    queryset = SiteLogo.objects.all().select_related('logo') 
    serializer_class = SiteLogoSerializer
    # Optimizing query with additional filtering or prefetching if there are other related fields
    def get_queryset(self):
        queryset = super().get_queryset()
        # Example: Using Prefetch for additional optimization if other related models are needed
        queryset = queryset.prefetch_related(
            Prefetch('logo', queryset=Image.objects.only('id', 'file'))
        )
        return queryset
 
 
class IdentityTypeList(APIView):
    permission_classes = [permissions.IsAuthenticated]
    def get(self, request, format=None):
        snippets = IdentityType.objects.all()
        serializer = IdentityTypeSerializer(snippets, many=True)
        return Response(serializer.data)


   
class FaviconAPI(APIView):
    def get(self, request, *args, **kwargs):
        favicon_data = cache.get('cached_favicon_image')
        if not favicon_data:
            favicon = FaviconSettings.objects.first()
            if not favicon or not favicon.base_favicon_image:
                return Response({"error": "Favicon not found"}, status=status.HTTP_404_NOT_FOUND)
            # Read the image content
            favicon_file = favicon.base_favicon_image.file.read()
            favicon_data = favicon_file
            # Cache the file data for future requests (e.g., 1 day)
            cache.set('cached_favicon_image', favicon_data, timeout=60 * 60 * 24)
        return HttpResponse(favicon_data, content_type="image/png")

  