from django.db import models

# Create your models here.
from django.contrib.auth.models import AbstractUser, Group, Permission,BaseUserManager
from wagtail.snippets.models import register_snippet
from wagtail.fields import RichTextField
from django.utils import timezone
import uuid

class CustomUser(AbstractUser):
    email = models.EmailField(unique=True)
    # Example: A flag for multi-factor authentication status
    mfa_enabled = models.BooleanField(default=False)
    # Add related_name to prevent clashes
    groups = models.ManyToManyField(
        Group,
        related_name='customuser_set',  # Change this to something unique
        blank=True
    )
    user_permissions = models.ManyToManyField(
        Permission,
        related_name='customuser_permissions',  # Change this to something unique
        blank=True
    )
    class Meta:
        verbose_name = "User"
        verbose_name_plural = "Users"
    def __str__(self):
        return self.email



