
from django.db import models
from wagtail.fields import StreamField
from wagtail.blocks import *
from wagtail.images.blocks import ImageChooserBlock
from django.core.validators import MaxValueValidator, MinValueValidator 
from wagtail_color_panel.fields import ColorField

from .baseSettings import *



class AnimationBlock(StructBlock):
    animation=ChoiceBlock(choices=[('l2r','Left to Right'),('r2l','Right to Left'),('t2b','Top to Bottom'),('b2t','Bottom to Top')],label="Text Animation",default="l2r",required=False)
    duration=IntegerBlock(default=2)
    
class AbstractCarousel(models.Model):
    bannerHeight = models.PositiveIntegerField(default=200,validators=[MinValueValidator(50), MaxValueValidator(2000)],verbose_name="Height")
    bannerWidth = models.PositiveIntegerField(default=600, validators=[MinValueValidator(150), MaxValueValidator(2560)],verbose_name="Width")
    bannerTimer = models.PositiveIntegerField(default=3000, help_text="Slide time in ms",verbose_name="Timer")
    bannercontent = StreamField(
        [
            ('slide', StructBlock([
                ("image", CustomImageChooserBlock(required=True)),
                ("opacity",ChoiceBlock(default=100,choices=[(25,'25%'),(50,'50%'),(75,'75%'),(100,'100%')],required=False)),
                ("content_loc",ChoiceBlock(choices=[('Left','Left'),('Center','Center'),('Right','Right')],label="Content Location",default="Left",required=False)),
                ("text_animation",ChoiceBlock(choices=[('l2r','Left to Right'),('r2l','Right to Left'),('t2b','Top to Bottom'),('b2t','Bottom to Top')],label="Text Animation",default="l2r",required=False)),
                ('content',StructBlock([
                    ("text_color", NativeColorBlock(required=False,default="#FFFFFF",label="Text Color")),
                    ("title", CharBlock(required=False)),
                    ("title_animation", AnimationBlock(required=False)),
                    ("desc", RichTextBlock(required=False,label="Description")),
                    ("desc_animation", AnimationBlock(required=False,label="Description Animation")),
                    ("action_btn",StructBlock([
                    ("menu", CustomMenuChooserBlock('web.Menu',required=False)),
                    ("page", CustomPageChooserBlock(required=False,label="Internal Link")),
                    ("bg", NativeColorBlock(required=False,default="#cc3d00",label="BG Color")),
                    ("fg", NativeColorBlock(required=False,default="#FFFFFF",label="FG Color")),
                    ],label="Action Button"))
                    
                ])),
            ]))
        ],blank=True,null=True,use_json_field=True,verbose_name="Content"
    )
    class Meta:
        abstract=True


class AbstractCustomColor(models.Model):
    bgColor = ColorField(
        default="#FFFFFF", verbose_name="BG", blank=True, null=True)
    fgColor = ColorField(
        default="#000000", verbose_name="FG", blank=True, null=True)

    hoverBgColor = ColorField(
        default="#FFFFFF", verbose_name="Hover BG", blank=True, null=True)
    hoverFgColor = ColorField(
        default="#000000", verbose_name="Hover FG", blank=True, null=True)
    
    activeBgColor = ColorField(
        default="#FFFFFF", verbose_name="Active BG", blank=True, null=True)
    activeFgColor = ColorField(
        default="#000000", verbose_name="Active FG", blank=True, null=True)
    class Meta:
        abstract=True