
THICKNESS_LIST=[
    ('1px','1px'),
    ('2px','2px'),
    ('3px','3px'),
    ('4px','4px'),
    ('5px','5px'),
    ('6px','6px'),
    ('7px','7px'),
]

new_table_options = {
    'minSpareRows': 0,
    'startRows': 3,
    'startCols': 2,
    'colHeaders': False,
    'rowHeaders': False,
    'contextMenu': True,
    'editor': 'text',
    'stretchH': 'all',
    'height': 108,
    'language': 'en',
    'renderer': 'text',
    'autoColumnSize': False,
}

FONT_TYPE_LIST = [
    ('Arial', 'Arial'),
    ("'Catamaran'", 'Catamaran'),
    ('Macklin Sans', 'Macklin Sans'),
    ('Helvetica', 'Helvetica'),
    ('sans-serif', 'sans-serif'),
    ('Georgia', 'Georgia'),
    ('Times New Roman', 'Times New Roman'),
]

FONT_SIZE_LIST = [
    ('10px', '10 px'),
    ('12px', '12 px'),
    ('14px', '14 px'),
    ('16px', '16 px'),
    ('18px', '18 px'),
    ('20px', '20 px'),
    ('22px', '22 px'),
    ('24px', '24 px'),
    ('26px', '26 px'),
    ('28px', '28 px'),
    ('30px', '30 px'),
    ('32px', '32 px'),
    ('34px', '34 px'),
    ('36px', '36 px'),
    ('48px', '48 px'),
    ('60px', '60 px'),
    ('72px', '72 px'),
    ('96px', '96 px'),
    ('128px', '128 px'),
]

ALIGNMENT_LIST = [
    ('text-left', 'Left'),
    ('text-right', 'Right'),
    ('text-center', 'Center'),
    ('text-justify', 'Justify'),
]

LINE_HEIGHT_LIST = [
    ('leading-none', 'None'),
    ('leading-tight', 'Normal'),
    ('leading-normal', 'Single'),
    ('leading-relaxed', '1.5 Line'),
    ('leading-loose', 'Double'),
]

PRODUCT_TEMPLATE_LIST = [
    ('left', 'Left'),
    ('right', 'right'),
]
from wagtail.blocks import *
from wagtail.admin.panels import FieldPanel, MultiFieldPanel, FieldRowPanel
from wagtail_color_panel.blocks import NativeColorBlock
from wagtailmodelchooser.blocks import ModelChooserBlock

class HeadingBlock(StructBlock):
    title = CharBlock()
    alignment = ChoiceBlock(choices=ALIGNMENT_LIST, required=False,default="text-left")
    size = ChoiceBlock(choices=FONT_SIZE_LIST, required=False,default="text-lg")
    Panels = [
        MultiFieldPanel([
            FieldRowPanel([
                FieldPanel('alignment'),
                FieldPanel('size')

            ])
        ])
    ]

class ParagraphBlock(StructBlock):
    text = RichTextBlock()
    alignment = ChoiceBlock(choices=ALIGNMENT_LIST, required=False,default="text-left")
    size = ChoiceBlock(choices=FONT_SIZE_LIST, required=False,default="text-base")
    line_space = ChoiceBlock(choices=LINE_HEIGHT_LIST,required=False,label="Line Spacing",default="leading-normal")


class QuoteBlock(StructBlock):
    quote = BlockQuoteBlock()
    alignment = ChoiceBlock(choices=ALIGNMENT_LIST, required=False,default="text-left")
    size = ChoiceBlock(choices=FONT_SIZE_LIST, required=False,default="text-base")
    line_space = ChoiceBlock(choices=LINE_HEIGHT_LIST, required=False,default="leading-normal")


class HRLine(StructBlock):
    color = NativeColorBlock(required=False, default="", label="BG Color")
    double_color = StructBlock([
        ('oneColor', NativeColorBlock(
            required=False, default="", label="One Color")),
        ('twoColor', NativeColorBlock(
            required=False, default="", label="Two Color")),
    ])
    gradient = CharBlock(required=False)
    width = DecimalBlock(default=100, label="Width (px)")
    thickness = DecimalBlock(default=4, label="Thickness (px)")
    margin = StructBlock([
        ('top', DecimalBlock(
            default=0, label="Top (px)")),
        ('bottom', DecimalBlock(
            default=8, label="Bottom (px)")),
    ])

class LineBreak(StructBlock):
    line_break = CharBlock(required=False, label="Line Break", readOnly=True)

from wagtail.images.blocks import ImageChooserBlock

class CustomPageChooserBlockWithImage(PageChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "title": value.title,
                "slug": value.slug,
                'icon':value.specific.menuIcon if value.specific.menuIcon else None,
                "image": value.search_image.file.url if value.search_image else None,
            }
        return None

class CustomPageChooserBlock(PageChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "title": value.title,
                "slug": value.slug,
                'icon':value.specific.menuIcon if value.specific.menuIcon else None,
                'menuName':value.specific.menuName if value.specific.menuName else None,
                # "image": value.search_image.file.url if value.search_image else None,
            }
        return None


class CustomImageChooserBlock(ImageChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "title": value.title,
                "file": value.file.url if value.file else None,
            }
        return None

class CompanyBlock(ModelChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "title": value.ciTitle,
                "name": value.ciName,
                "type": value.ciType,
                "logo_url": value.ciLogo.file.url if value.ciLogo else None,
                "logo_text": value.ciLogoText,
                "body": value.ciBody.get_prep_value() if value.ciBody else None,
            }
        return None

class CustomMegaMenuChooserBlock(ModelChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "name": value.name,
                "icon": value.icon,
                "image": value.image,
                "items": [
                    {
                        "id": item.id,
                        "title": item.title,
                        "body": item.body.get_prep_value()  # Optional: `item.body.get_prep_value()` also works
                    }
                    for item in value.mega_items.all()
                ],                # "logo_text": value.ciLogoText,
                # "body": value.ciBody.get_prep_value() if value.ciBody else None,
            }
        return None



class CustomMenuChooserBlock(ModelChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "title": value.title,
                "slug": value.slug,
                "icon": value.icon,
                "page":{'id':value.page.id,'title':value.page.title,'slug':value.page.slug} if value.page else None,
                "is_dropdown": value.is_dropdown,
                "menu_items": [
                    {
                        "id": item.id,
                        "title": item.title,
                        "slug": item.slug,
                        "icon": item.icon,
                        "page_id": item.page_id,
                        "document": {
                            "id": item.document.id,
                            "title": item.document.title,
                            "file": item.document.file.url,
                        } if item.document else None,
                        "service": {
                            "id": item.service.id,
                            "title": item.service.title,
                            "cat_slug": item.service.cat.slug,
                            "slug": item.service.slug,
                        } if item.service else None
                    }
                    for item in value.menu_items.all()
                ]
            }
        return None
    
    
    
    
    
    