from wagtail.blocks import *
from wagtail.images.blocks import ImageChooserBlock
from wagtail.admin.panels import FieldPanel, MultiFieldPanel, FieldRowPanel
from wagtailmodelchooser.blocks import ModelChooserBlock
# from Comp.models import ExportCountry
from wagtail_color_panel.blocks import NativeColorBlock
from wagtail.documents.blocks import DocumentChooserBlock
from wagtail.contrib.table_block.blocks import TableBlock

from .baseSettings import *


class DocumentBlock(StreamBlock):
    doc_content = StructBlock([
        ("title", CharBlock(required=False)),
        ("doc", DocumentChooserBlock(required=False)),
        ("image", ImageChooserBlock(required=False)),
    ])

    class Meta:
        icon = 'documents'

# class PopupCornerBtnBlock(StructBlock):
#     bg = IntegerBlock(default=200, min=150, max=400)
#     hoberBG = IntegerBlock(default=400, min=350, max=600)
#     icon = IntegerBlock(default=2000, help_text="Slide time in ms")
#     iconColor=NativeColorBlock()
    
class CarouselBlock(StructBlock):
    height = IntegerBlock(default=200, min=150, max=400)
    width = IntegerBlock(default=400, min=350, max=600)
    timer = IntegerBlock(default=2000, help_text="Slide time in ms")
    content = StreamBlock(
        [
            ('slide', StructBlock([
                ("image", ImageChooserBlock(required=True)),
                ("title", CharBlock(required=False)),
            ]))
        ]
    )
    # class Meta:
    #     icon = 'user'


class TileViewBlock(StreamBlock):
    tile = StructBlock([
        ("round", BooleanBlock(required=False,labe="Rounded Edge")),
        ("tileBgColor", NativeColorBlock(default="#1F1E1E", label="Tile BG Color")),
        ("tileFgColor", NativeColorBlock(default="#FFFFFF", label="Tile BG Color")),
        ("image", CustomImageChooserBlock(required=False)),
        ("icon", CharBlock(required=False)),
        ("title", CharBlock(required=False)),
        ("desc", RichTextBlock(required=False,label="Description")),
        
    ])



class CustomCategoryChooserBlock(ModelChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "title": value.name,
                "slug": value.slug,
                # "image": value.soLogo.file.url if value.soLogo else None,
            }
        return None
    
    
class SocialChooserBlock(ModelChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "title": value.soTitle,
                "logo_url": value.soLogo.file.url if value.soLogo else None,
                'icon':value.soLogoText,
                "url": value.soUrl,
            }
        return None


class CustomPolicyChooserBlock(ModelChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "title": value.title,
                "slug": value.slug,
            }
        return None

class CustomServiceChooserBlock(ModelChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "title": value.title,
                "slug": value.slug,
                "cat_slug": value.cat.slug,
                "icon": value.icon,
                "imgIcon": value.imgIcon.file.url if value.imgIcon else None,
            }
        return None  
class CustomServiceCatChooserBlock(ModelChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "title": value.title,
                "slug": value.slug,
            }
        return None

  
        
class CustomSiteLogoChooserBlock(ModelChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "logo_url": value.logo.file.url if value.logo else None,
            }
        return None
  
    
class CompEmailChooserBlock(ModelChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "coEmail": value.coEmail,
            }
        return None

   
class CompContactChooserBlock(ModelChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "coContact": value.coContact,
            }
        return None
    
class CompWebChooserBlock(ModelChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "coWeb": value.coWeb,
            }
        return None

class CompLogoChooserBlock(ModelChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "coLogo": value.coLogo.file.url,
            }
        return None


class CompFavChooserBlock(ModelChooserBlock):
    def get_api_representation(self, value, context=None):
        if value:
            return {
                "id": value.id,
                "coFav": value.coFav.file.url,
            }
        return None

class SocialBlock(StreamBlock):
    social_link = SocialChooserBlock('web.Social')




class AccordionTitleBlock(StructBlock):
    title = CharBlock()
    size = ChoiceBlock(choices=FONT_SIZE_LIST, required=False)


class AccordionDetailBlock(StructBlock):
    desc = RichTextBlock()
    size = ChoiceBlock(choices=FONT_SIZE_LIST, required=False)
    alignment = ChoiceBlock(choices=ALIGNMENT_LIST, required=False)
    line_space = ChoiceBlock(choices=LINE_HEIGHT_LIST, required=False)


class AccordBlock(StructBlock):
    title = AccordionTitleBlock()
    detail = AccordionDetailBlock()


class AccordionBlock(StreamBlock):
    accord_items = AccordBlock()


class BaseColumnBlock(StructBlock):
    fontType = ChoiceBlock(choices=FONT_TYPE_LIST, required=False)
    content = StreamBlock([
        ("heading", HeadingBlock(required=False)),
        ("paragraph", ParagraphBlock(required=False)),
        ("image", CustomImageChooserBlock(required=False)),
        ("quote", QuoteBlock(required=False)),
        # ("social", SocialBlock(required=False)),
        ('accordion', AccordionBlock(required=False)),
        ("tile_View", TileViewBlock(required=False)),
        ("show_enq_form", BooleanBlock(required=False, label="Show Enquiry Form")),
        ("show_demand_form", BooleanBlock(required=False, label="Show Demand Form"))
    ])



class BaseRowBlock(StructBlock):               
    bgColor = NativeColorBlock(default="#000000", label="BG Color")
    fgColor = NativeColorBlock(default="#FFFFFF", label="FG Color")
    title = CharBlock(required=False)  
    content = StreamBlock(
        [
            ("column", BaseColumnBlock(required=False))
        ], required=False
    )


class ColumnBlock(StructBlock):
    fontType = ChoiceBlock(choices=FONT_TYPE_LIST, required=False)
    width = CharBlock(default="50%", required=False)
    bgColor = NativeColorBlock(default="#FFFFFF", label="BG Color")
    fgColor = NativeColorBlock(default="#000000", label="FG Color")
    content = StreamBlock([
        ("heading", HeadingBlock(required=False)),
        ("line_break", CharBlock(required=False, label="Line Break", readOnly=True)),
        ("hr_line", StructBlock([
            ('color', NativeColorBlock(required=False, default="", label="BG Color")),
            ('double_color', StructBlock([
                ('oneColor', NativeColorBlock(
                    required=False, default="", label="One Color")),
                ('twoColor', NativeColorBlock(
                    required=False, default="", label="Two Color")),
            ])),
            ('gradient', CharBlock(required=False)),
            ('width', CharBlock(default='100', label="Width (px)")),
            ('thickness', CharBlock(default="4", label="Thickness (px)")),
            ('margin', StructBlock([
                ('top', DecimalBlock(
                    default=0, label="Top (px)")),
                ('bottom', DecimalBlock(
                    default=8, label="Bottom (px)")),
            ])),
        ], required=False, label="HR Line",)),
        ("paragraph", ParagraphBlock(required=False)),
        ("image", CustomImageChooserBlock(required=False)),
        ("quote", QuoteBlock(required=False)),
        
        # ("social", SocialBlock(required=False)),
        ("sub_row", BaseRowBlock(required=False)),
        ('accordion', AccordionBlock(required=False)),
        ("link", CustomPageChooserBlock(required=False)),
        ("tile_View", TileViewBlock(required=False)),
        ("show_comp", BooleanBlock(required=False, label="Show Company Detail")),
        ("show_enq_form", BooleanBlock(required=False, label="Show Enquiry Form")),
        ("show_demand_form", BooleanBlock(required=False, label="Show Demand Form"))
    ], required=False)


# Main Blocks


class RowBlock(StructBlock):
    bgImage= CustomImageChooserBlock(required=False,label="BG Image")
    bgColor = NativeColorBlock(default="#FFFFFF", label="BG Color")
    bgOpacity=ChoiceBlock(default=100,choices=[(25,'25%'),(50,'50%'),(75,'75%'),(100,'100%')],required=False)
    fill_pattern = CharBlock(required=False,label="Fill Pattern")
    fgColor = NativeColorBlock(default="#000000", label="FG Color")
    fontType = ChoiceBlock(choices=FONT_TYPE_LIST, required=False)
    title = CharBlock(required=False,label="Heading")
    main_title = CharBlock(required=False,label="Main Title")

    content = StreamBlock(
        [
            ("column", ColumnBlock(required=False))
        ], required=False
    )


class SectionBlock(StructBlock):
    bgImage= CustomImageChooserBlock(required=False,label="BG Image")
    bgColor = NativeColorBlock(default="#FFFFFF", label="BG Color")
    bgOpacity=ChoiceBlock(default=100,choices=[(25,'25%'),(50,'50%'),(75,'75%'),(100,'100%')],required=False)
    fill_pattern = CharBlock(required=False,label="Fill Pattern")
    fgColor = NativeColorBlock(default="#000000", label="FG Color")
    fontType = ChoiceBlock(choices=FONT_TYPE_LIST, required=False)
    title = CharBlock(required=False,label="Heading")
    main_title = CharBlock(required=False,label="Main Title")
    content = StreamBlock(
        [
            ("heading", HeadingBlock(required=False)),
            ("paragraph", ParagraphBlock(required=False)),
            ("image", CustomImageChooserBlock(required=False)),
            ("quote", QuoteBlock(required=False)),
            ("accordion", AccordionBlock(required=False)),
            ("show_services", BooleanBlock(required=False, label="Show Services")),
            ("show_industries", BooleanBlock(required=False, label="Show Industries")),
            ("show_clients", BooleanBlock(required=False, label="Show Clients")),
            ("show_enq", BooleanBlock(required=False, label="Show Enquiry")),
            
            ("tile_View", TileViewBlock(required=False)),
        ], required=False
    )
    # class Meta:
    #     icon = 'user'


# Footer Blocks


# class FooterBaseColumnBlock(StructBlock):
#     width = CharBlock(default="50%", required=False)
#     content = StreamBlock([
#         ("heading", HeadingBlock(required=False)),
#         ("paragraph", ParagraphBlock(required=False)),
#         ("model", CustomPageChooserBlock('Product.ModalPage')),
#         ("social", SocialBlock(required=False)),
#         ("company", ComInfoBlock(required=False)),
#         ("policy", ModelChooserBlock('Comp.Policy')),
#         ("image", ImageChooserBlock(required=False)),
#         ("category", CategoryBlock(required=False)),
#         ("link", CustomPageChooserBlock(required=False)),
#     ])


# class FooterBaseRowBlock(StreamBlock):
#     column=FooterBaseColumnBlock(required=False)


class FooterColumnBlock(StructBlock):
    width = CharBlock(default="50%", required=False)
    content = StreamBlock([
        ("heading", HeadingBlock(required=False)),
        ("hr_line", StructBlock([
            ('color', NativeColorBlock(required=False, default="", label="BG Color")),
            ('double_color', StructBlock([
                ('oneColor', NativeColorBlock(
                    required=False, default="", label="One Color")),
                ('twoColor', NativeColorBlock(
                    required=False, default="", label="Two Color")),
            ])),
            ('gradient', CharBlock(required=False)),
            ('width', CharBlock(default='100', label="Width (px)")),
            ('thickness', CharBlock(default="4", label="Thickness (px)")),
            ('margin', StructBlock([
                ('top', DecimalBlock(
                    default=0, label="Top (px)")),
                ('bottom', DecimalBlock(
                    default=8, label="Bottom (px)")),
            ])),
        ], required=False, label="HR Line",)),
        ("line_break", CharBlock(required=False, label="Line Break", readOnly=True)),
        ("paragraph", ParagraphBlock(required=False)),
        ("service", CustomServiceChooserBlock('web.Services')),
        ("social", SocialBlock(required=False)),
        ("policy", CustomPolicyChooserBlock('web.Policy')),
        ("menu", CustomMenuChooserBlock('web.Menu')),
        # ("sub_row", FooterBaseRowBlock(required=False)),
        ("image", CustomImageChooserBlock(required=False)),
        ("show_comp", BooleanBlock(required=False, label="Show Company Detail")),
        ("link", CustomPageChooserBlock(required=False)),
    ], required=False)


class FooterRowBlock(StructBlock):
    bgColor = NativeColorBlock(default="#FFFFFF", label="BG Color")
    fgColor = NativeColorBlock(default="#000000", label="FG Color")
    content = StreamBlock(
        [
            ("column", FooterColumnBlock(required=False))
        ], required=False
    )


