# Generated by Django 5.2.4 on 2025-07-19 06:05

import django.core.validators
import django.db.models.deletion
import django_extensions.db.fields
import modelcluster.fields
import uuid
import wagtail.fields
import wagtail_color_panel.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('wagtailcore', '0094_alter_page_locale'),
        ('wagtaildocs', '0014_alter_document_file_size'),
        ('wagtailimages', '0027_image_description'),
    ]

    operations = [
        migrations.CreateModel(
            name='BottomFooter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('bgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG Color')),
                ('fgColor', wagtail_color_panel.fields.ColorField(default='#000000', max_length=7, verbose_name='FG Color')),
                ('fontType', models.CharField(blank=True, choices=[('Arial', 'Arial'), ("'Catamaran'", 'Catamaran'), ('Macklin Sans', 'Macklin Sans'), ('Helvetica', 'Helvetica'), ('sans-serif', 'sans-serif'), ('Georgia', 'Georgia'), ('Times New Roman', 'Times New Roman')], max_length=200, null=True, verbose_name='Font Type')),
                ('size', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], default='text-sm', max_length=200, null=True)),
                ('content', wagtail.fields.StreamField([('row', 3)], blank=True, block_lookup={0: ('web.blocks.CustomPolicyChooserBlock', (), {'target_model': 'web.policy'}), 1: ('wagtail.blocks.RichTextBlock', (), {}), 2: ('wagtail.blocks.StreamBlock', [[('policy', 0), ('paragraph', 1)]], {'required': False}), 3: ('wagtail.blocks.StreamBlock', [[('column', 2)]], {})}, null=True)),
            ],
            options={
                'verbose_name_plural': 'Bottom Footer',
            },
        ),
        migrations.CreateModel(
            name='Footer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default='Footer', max_length=200)),
                ('body', wagtail.fields.StreamField([('row', 33)], blank=True, block_lookup={0: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '#FFFFFF', 'label': 'BG Color'}), 1: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '#000000', 'label': 'FG Color'}), 2: ('wagtail.blocks.CharBlock', (), {'default': '50%', 'required': False}), 3: ('wagtail.blocks.CharBlock', (), {}), 4: ('wagtail.blocks.ChoiceBlock', [], {'choices': [('text-left', 'Left'), ('text-right', 'Right'), ('text-center', 'Center'), ('text-justify', 'Justify')], 'required': False}), 5: ('wagtail.blocks.ChoiceBlock', [], {'choices': [('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], 'required': False}), 6: ('wagtail.blocks.StructBlock', [[('title', 3), ('alignment', 4), ('size', 5)]], {'required': False}), 7: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '', 'label': 'BG Color', 'required': False}), 8: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '', 'label': 'One Color', 'required': False}), 9: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '', 'label': 'Two Color', 'required': False}), 10: ('wagtail.blocks.StructBlock', [[('oneColor', 8), ('twoColor', 9)]], {}), 11: ('wagtail.blocks.CharBlock', (), {'required': False}), 12: ('wagtail.blocks.CharBlock', (), {'default': '100', 'label': 'Width (px)'}), 13: ('wagtail.blocks.CharBlock', (), {'default': '4', 'label': 'Thickness (px)'}), 14: ('wagtail.blocks.DecimalBlock', (), {'default': 0, 'label': 'Top (px)'}), 15: ('wagtail.blocks.DecimalBlock', (), {'default': 8, 'label': 'Bottom (px)'}), 16: ('wagtail.blocks.StructBlock', [[('top', 14), ('bottom', 15)]], {}), 17: ('wagtail.blocks.StructBlock', [[('color', 7), ('double_color', 10), ('gradient', 11), ('width', 12), ('thickness', 13), ('margin', 16)]], {'label': 'HR Line', 'required': False}), 18: ('wagtail.blocks.CharBlock', (), {'label': 'Line Break', 'readOnly': True, 'required': False}), 19: ('wagtail.blocks.RichTextBlock', (), {}), 20: ('wagtail.blocks.ChoiceBlock', [], {'choices': [('leading-none', 'None'), ('leading-tight', 'Normal'), ('leading-normal', 'Single'), ('leading-relaxed', '1.5 Line'), ('leading-loose', 'Double')], 'label': 'Line Spacing', 'required': False}), 21: ('wagtail.blocks.StructBlock', [[('text', 19), ('alignment', 4), ('size', 5), ('line_space', 20)]], {'required': False}), 22: ('web.blocks.CustomServiceChooserBlock', (), {'target_model': 'web.services'}), 23: ('web.blocks.SocialChooserBlock', (), {'target_model': 'web.social'}), 24: ('wagtail.blocks.StreamBlock', [[('social_link', 23)]], {'required': False}), 25: ('web.blocks.CustomPolicyChooserBlock', (), {'target_model': 'web.policy'}), 26: ('web.baseSettings.CustomMenuChooserBlock', (), {'target_model': 'web.menu'}), 27: ('web.baseSettings.CustomImageChooserBlock', (), {'required': False}), 28: ('wagtail.blocks.BooleanBlock', (), {'label': 'Show Company Detail', 'required': False}), 29: ('web.baseSettings.CustomPageChooserBlock', (), {'required': False}), 30: ('wagtail.blocks.StreamBlock', [[('heading', 6), ('hr_line', 17), ('line_break', 18), ('paragraph', 21), ('service', 22), ('social', 24), ('policy', 25), ('menu', 26), ('image', 27), ('show_comp', 28), ('link', 29)]], {'required': False}), 31: ('wagtail.blocks.StructBlock', [[('width', 2), ('content', 30)]], {'required': False}), 32: ('wagtail.blocks.StreamBlock', [[('column', 31)]], {'required': False}), 33: ('wagtail.blocks.StructBlock', [[('bgColor', 0), ('fgColor', 1), ('content', 32)]], {})}, null=True)),
            ],
            options={
                'verbose_name_plural': 'Footer',
            },
        ),
        migrations.CreateModel(
            name='Header',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(choices=[('Top Header', 'Top Header'), ('Header', 'Header'), ('Mobile Header', 'Mobile Header'), ('Bottom Menu', 'Bottom Menu'), ('Burger Menu', 'Burger Menu')], max_length=200, unique=True)),
                ('fontType', models.CharField(blank=True, choices=[('Arial', 'Arial'), ("'Catamaran'", 'Catamaran'), ('Macklin Sans', 'Macklin Sans'), ('Helvetica', 'Helvetica'), ('sans-serif', 'sans-serif'), ('Georgia', 'Georgia'), ('Times New Roman', 'Times New Roman')], max_length=200, null=True)),
                ('size', models.CharField(blank=True, choices=[('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], default='text-sm', max_length=200, null=True)),
                ('content', wagtail.fields.StreamField([('row', 39)], blank=True, block_lookup={0: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '#FFFFFF', 'label': 'BG Color'}), 1: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '#000000', 'label': 'FG Color'}), 2: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '#000000', 'label': 'Hover BG Color'}), 3: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '#FFFFFF', 'label': 'Hover FG Color'}), 4: ('web.blocks.CompEmailChooserBlock', (), {'target_model': 'web.company'}), 5: ('web.blocks.CompContactChooserBlock', (), {'target_model': 'web.company'}), 6: ('web.blocks.CompWebChooserBlock', (), {'target_model': 'web.company'}), 7: ('wagtail.blocks.StreamBlock', [[('email', 4), ('contact', 5), ('web', 6)]], {}), 8: ('web.blocks.SocialChooserBlock', (), {'target_model': 'web.social'}), 9: ('wagtail.blocks.StreamBlock', [[('social_link', 8)]], {}), 10: ('web.blocks.CustomSiteLogoChooserBlock', (), {'target_model': 'core.sitelogo'}), 11: ('web.baseSettings.CustomPageChooserBlock', (), {'required': False}), 12: ('wagtail.blocks.BooleanBlock', (), {'default': False, 'required': False}), 13: ('wagtail.blocks.CharBlock', (), {'required': False}), 14: ('web.baseSettings.CustomImageChooserBlock', (), {'required': False}), 15: ('wagtail.blocks.CharBlock', (), {}), 16: ('wagtail.blocks.ChoiceBlock', [], {'choices': [('text-left', 'Left'), ('text-right', 'Right'), ('text-center', 'Center'), ('text-justify', 'Justify')], 'required': False}), 17: ('wagtail.blocks.ChoiceBlock', [], {'choices': [('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], 'required': False}), 18: ('wagtail.blocks.StructBlock', [[('title', 15), ('alignment', 16), ('size', 17)]], {'required': False}), 19: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '', 'label': 'BG Color', 'required': False}), 20: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '', 'label': 'One Color', 'required': False}), 21: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '', 'label': 'Two Color', 'required': False}), 22: ('wagtail.blocks.StructBlock', [[('oneColor', 20), ('twoColor', 21)]], {}), 23: ('wagtail.blocks.DecimalBlock', (), {'default': 100, 'label': 'Width (px)'}), 24: ('wagtail.blocks.DecimalBlock', (), {'default': 4, 'label': 'Thickness (px)'}), 25: ('wagtail.blocks.DecimalBlock', (), {'default': 0, 'label': 'Top (px)'}), 26: ('wagtail.blocks.DecimalBlock', (), {'default': 8, 'label': 'Bottom (px)'}), 27: ('wagtail.blocks.StructBlock', [[('top', 25), ('bottom', 26)]], {}), 28: ('wagtail.blocks.StructBlock', [[('color', 19), ('double_color', 22), ('gradient', 13), ('width', 23), ('thickness', 24), ('margin', 27)]], {'required': False}), 29: ('wagtail.blocks.CharBlock', (), {'label': 'Line Break', 'readOnly': True, 'required': False}), 30: ('wagtail.blocks.StructBlock', [[('line_break', 29)]], {'required': False}), 31: ('wagtail.blocks.StructBlock', [[('text', 13), ('icon', 13), ('url', 15)]], {}), 32: ('wagtail.blocks.StructBlock', [[('image', 14), ('page', 11), ('text', 13)]], {'label': 'Thumbnail'}), 33: ('wagtail.blocks.StreamBlock', [[('heading', 18), ('hr_line', 28), ('line_break', 30), ('page', 11), ('link', 31), ('option', 32)]], {'required': False}), 34: ('wagtail.blocks.StreamBlock', [[('col', 33)]], {'required': False}), 35: ('wagtail.blocks.StructBlock', [[('page', 11), ('name', 13), ('icon', 13), ('image', 14), ('body', 34)]], {}), 36: ('web.baseSettings.CustomMenuChooserBlock', (), {'target_model': 'web.menu'}), 37: ('wagtail.blocks.StreamBlock', [[('company_info', 7), ('social', 9), ('logo', 10), ('page', 11), ('show_login', 12), ('show_search', 12), ('show_burger_menu', 12), ('show_get_quote', 12), ('mega_menu', 35), ('menu', 36)]], {'required': False}), 38: ('wagtail.blocks.StreamBlock', [[('column', 37)]], {}), 39: ('wagtail.blocks.StructBlock', [[('bgColor', 0), ('fgColor', 1), ('hoverBgColor', 2), ('hoverFgColor', 3), ('content', 38)]], {})}, null=True)),
                ('iconBG', wagtail_color_panel.fields.ColorField(default='#cc3d00', max_length=7)),
                ('iconFG', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7)),
                ('iconHoverBG', wagtail_color_panel.fields.ColorField(default='#cc3d00', max_length=7)),
                ('iconHoverFG', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7)),
                ('icon', models.CharField(blank=True, max_length=200, null=True)),
                ('shape', models.CharField(blank=True, choices=[('Circle', 'Circle'), ('Rounded Square', 'Rounded Square')], default='Circle', max_length=200, null=True)),
            ],
            options={
                'verbose_name_plural': 'Header Settings',
            },
        ),
        migrations.CreateModel(
            name='Policy',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200, unique=True)),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='title', unique=True)),
                ('detail', wagtail.fields.RichTextField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'Policy',
                'verbose_name_plural': 'Policies',
            },
        ),
        migrations.CreateModel(
            name='WebPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.page')),
                ('bannerHeight', models.PositiveIntegerField(default=200, validators=[django.core.validators.MinValueValidator(50), django.core.validators.MaxValueValidator(2000)], verbose_name='Height')),
                ('bannerWidth', models.PositiveIntegerField(default=600, validators=[django.core.validators.MinValueValidator(150), django.core.validators.MaxValueValidator(2560)], verbose_name='Width')),
                ('bannerTimer', models.PositiveIntegerField(default=3000, help_text='Slide time in ms', verbose_name='Timer')),
                ('bannercontent', wagtail.fields.StreamField([('slide', 16)], blank=True, block_lookup={0: ('web.baseSettings.CustomImageChooserBlock', (), {'required': True}), 1: ('wagtail.blocks.ChoiceBlock', [], {'choices': [(25, '25%'), (50, '50%'), (75, '75%'), (100, '100%')], 'required': False}), 2: ('wagtail.blocks.ChoiceBlock', [], {'choices': [('Left', 'Left'), ('Center', 'Center'), ('Right', 'Right')], 'label': 'Content Location', 'required': False}), 3: ('wagtail.blocks.ChoiceBlock', [], {'choices': [('l2r', 'Left to Right'), ('r2l', 'Right to Left'), ('t2b', 'Top to Bottom'), ('b2t', 'Bottom to Top')], 'label': 'Text Animation', 'required': False}), 4: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '#FFFFFF', 'label': 'Text Color', 'required': False}), 5: ('wagtail.blocks.CharBlock', (), {'required': False}), 6: ('wagtail.blocks.IntegerBlock', (), {'default': 2}), 7: ('wagtail.blocks.StructBlock', [[('animation', 3), ('duration', 6)]], {'required': False}), 8: ('wagtail.blocks.RichTextBlock', (), {'label': 'Description', 'required': False}), 9: ('wagtail.blocks.StructBlock', [[('animation', 3), ('duration', 6)]], {'label': 'Description Animation', 'required': False}), 10: ('web.baseSettings.CustomMenuChooserBlock', (), {'required': False, 'target_model': 'web.menu'}), 11: ('web.baseSettings.CustomPageChooserBlock', (), {'label': 'Internal Link', 'required': False}), 12: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '#cc3d00', 'label': 'BG Color', 'required': False}), 13: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '#FFFFFF', 'label': 'FG Color', 'required': False}), 14: ('wagtail.blocks.StructBlock', [[('menu', 10), ('page', 11), ('bg', 12), ('fg', 13)]], {'label': 'Action Button'}), 15: ('wagtail.blocks.StructBlock', [[('text_color', 4), ('title', 5), ('title_animation', 7), ('desc', 8), ('desc_animation', 9), ('action_btn', 14)]], {}), 16: ('wagtail.blocks.StructBlock', [[('image', 0), ('opacity', 1), ('content_loc', 2), ('text_animation', 3), ('content', 15)]], {})}, null=True, verbose_name='Content')),
                ('body', wagtail.fields.StreamField([('section', 35), ('row', 61)], blank=True, block_lookup={0: ('web.baseSettings.CustomImageChooserBlock', (), {'label': 'BG Image', 'required': False}), 1: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '#FFFFFF', 'label': 'BG Color'}), 2: ('wagtail.blocks.ChoiceBlock', [], {'choices': [(25, '25%'), (50, '50%'), (75, '75%'), (100, '100%')], 'required': False}), 3: ('wagtail.blocks.CharBlock', (), {'label': 'Fill Pattern', 'required': False}), 4: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '#000000', 'label': 'FG Color'}), 5: ('wagtail.blocks.ChoiceBlock', [], {'choices': [('Arial', 'Arial'), ("'Catamaran'", 'Catamaran'), ('Macklin Sans', 'Macklin Sans'), ('Helvetica', 'Helvetica'), ('sans-serif', 'sans-serif'), ('Georgia', 'Georgia'), ('Times New Roman', 'Times New Roman')], 'required': False}), 6: ('wagtail.blocks.CharBlock', (), {'label': 'Heading', 'required': False}), 7: ('wagtail.blocks.CharBlock', (), {'label': 'Main Title', 'required': False}), 8: ('wagtail.blocks.CharBlock', (), {}), 9: ('wagtail.blocks.ChoiceBlock', [], {'choices': [('text-left', 'Left'), ('text-right', 'Right'), ('text-center', 'Center'), ('text-justify', 'Justify')], 'required': False}), 10: ('wagtail.blocks.ChoiceBlock', [], {'choices': [('text-xs', '10 px'), ('text-sm', '12 px'), ('text-base', '14 px'), ('16px', '16 px'), ('text-[18px]', '18 px'), ('text-xl', '20 px'), ('text-[22px]', '22 px'), ('text-2xl', '24 px'), ('text-[26px]', '26 px'), ('text-[28px]', '28 px'), ('text-3xl', '30 px'), ('text-[32px]', '32 px'), ('text-[34px]', '34 px'), ('text-4xl', '36 px'), ('text-5xl', '48 px'), ('text-6xl', '60 px'), ('text-7xl', '72 px'), ('text-8xl', '96 px'), ('text-9xl', '128 px')], 'required': False}), 11: ('wagtail.blocks.StructBlock', [[('title', 8), ('alignment', 9), ('size', 10)]], {'required': False}), 12: ('wagtail.blocks.RichTextBlock', (), {}), 13: ('wagtail.blocks.ChoiceBlock', [], {'choices': [('leading-none', 'None'), ('leading-tight', 'Normal'), ('leading-normal', 'Single'), ('leading-relaxed', '1.5 Line'), ('leading-loose', 'Double')], 'label': 'Line Spacing', 'required': False}), 14: ('wagtail.blocks.StructBlock', [[('text', 12), ('alignment', 9), ('size', 10), ('line_space', 13)]], {'required': False}), 15: ('web.baseSettings.CustomImageChooserBlock', (), {'required': False}), 16: ('wagtail.blocks.BlockQuoteBlock', (), {}), 17: ('wagtail.blocks.ChoiceBlock', [], {'choices': [('leading-none', 'None'), ('leading-tight', 'Normal'), ('leading-normal', 'Single'), ('leading-relaxed', '1.5 Line'), ('leading-loose', 'Double')], 'required': False}), 18: ('wagtail.blocks.StructBlock', [[('quote', 16), ('alignment', 9), ('size', 10), ('line_space', 17)]], {'required': False}), 19: ('wagtail.blocks.StructBlock', [[('title', 8), ('size', 10)]], {}), 20: ('wagtail.blocks.StructBlock', [[('desc', 12), ('size', 10), ('alignment', 9), ('line_space', 17)]], {}), 21: ('wagtail.blocks.StructBlock', [[('title', 19), ('detail', 20)]], {}), 22: ('wagtail.blocks.StreamBlock', [[('accord_items', 21)]], {'required': False}), 23: ('wagtail.blocks.BooleanBlock', (), {'label': 'Show Services', 'required': False}), 24: ('wagtail.blocks.BooleanBlock', (), {'label': 'Show Industries', 'required': False}), 25: ('wagtail.blocks.BooleanBlock', (), {'label': 'Show Clients', 'required': False}), 26: ('wagtail.blocks.BooleanBlock', (), {'label': 'Show Enquiry', 'required': False}), 27: ('wagtail.blocks.BooleanBlock', (), {'labe': 'Rounded Edge', 'required': False}), 28: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '#1F1E1E', 'label': 'Tile BG Color'}), 29: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '#FFFFFF', 'label': 'Tile BG Color'}), 30: ('wagtail.blocks.CharBlock', (), {'required': False}), 31: ('wagtail.blocks.RichTextBlock', (), {'label': 'Description', 'required': False}), 32: ('wagtail.blocks.StructBlock', [[('round', 27), ('tileBgColor', 28), ('tileFgColor', 29), ('image', 15), ('icon', 30), ('title', 30), ('desc', 31)]], {}), 33: ('wagtail.blocks.StreamBlock', [[('tile', 32)]], {'required': False}), 34: ('wagtail.blocks.StreamBlock', [[('heading', 11), ('paragraph', 14), ('image', 15), ('quote', 18), ('accordion', 22), ('show_services', 23), ('show_industries', 24), ('show_clients', 25), ('show_enq', 26), ('tile_View', 33)]], {'required': False}), 35: ('wagtail.blocks.StructBlock', [[('bgImage', 0), ('bgColor', 1), ('bgOpacity', 2), ('fill_pattern', 3), ('fgColor', 4), ('fontType', 5), ('title', 6), ('main_title', 7), ('content', 34)]], {}), 36: ('wagtail.blocks.CharBlock', (), {'default': '50%', 'required': False}), 37: ('wagtail.blocks.CharBlock', (), {'label': 'Line Break', 'readOnly': True, 'required': False}), 38: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '', 'label': 'BG Color', 'required': False}), 39: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '', 'label': 'One Color', 'required': False}), 40: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '', 'label': 'Two Color', 'required': False}), 41: ('wagtail.blocks.StructBlock', [[('oneColor', 39), ('twoColor', 40)]], {}), 42: ('wagtail.blocks.CharBlock', (), {'default': '100', 'label': 'Width (px)'}), 43: ('wagtail.blocks.CharBlock', (), {'default': '4', 'label': 'Thickness (px)'}), 44: ('wagtail.blocks.DecimalBlock', (), {'default': 0, 'label': 'Top (px)'}), 45: ('wagtail.blocks.DecimalBlock', (), {'default': 8, 'label': 'Bottom (px)'}), 46: ('wagtail.blocks.StructBlock', [[('top', 44), ('bottom', 45)]], {}), 47: ('wagtail.blocks.StructBlock', [[('color', 38), ('double_color', 41), ('gradient', 30), ('width', 42), ('thickness', 43), ('margin', 46)]], {'label': 'HR Line', 'required': False}), 48: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '#000000', 'label': 'BG Color'}), 49: ('wagtail_color_panel.blocks.NativeColorBlock', (), {'default': '#FFFFFF', 'label': 'FG Color'}), 50: ('wagtail.blocks.BooleanBlock', (), {'label': 'Show Enquiry Form', 'required': False}), 51: ('wagtail.blocks.BooleanBlock', (), {'label': 'Show Demand Form', 'required': False}), 52: ('wagtail.blocks.StreamBlock', [[('heading', 11), ('paragraph', 14), ('image', 15), ('quote', 18), ('accordion', 22), ('tile_View', 33), ('show_enq_form', 50), ('show_demand_form', 51)]], {}), 53: ('wagtail.blocks.StructBlock', [[('fontType', 5), ('content', 52)]], {'required': False}), 54: ('wagtail.blocks.StreamBlock', [[('column', 53)]], {'required': False}), 55: ('wagtail.blocks.StructBlock', [[('bgColor', 48), ('fgColor', 49), ('title', 30), ('content', 54)]], {'required': False}), 56: ('web.baseSettings.CustomPageChooserBlock', (), {'required': False}), 57: ('wagtail.blocks.BooleanBlock', (), {'label': 'Show Company Detail', 'required': False}), 58: ('wagtail.blocks.StreamBlock', [[('heading', 11), ('line_break', 37), ('hr_line', 47), ('paragraph', 14), ('image', 15), ('quote', 18), ('sub_row', 55), ('accordion', 22), ('link', 56), ('tile_View', 33), ('show_comp', 57), ('show_enq_form', 50), ('show_demand_form', 51)]], {'required': False}), 59: ('wagtail.blocks.StructBlock', [[('fontType', 5), ('width', 36), ('bgColor', 1), ('fgColor', 4), ('content', 58)]], {'required': False}), 60: ('wagtail.blocks.StreamBlock', [[('column', 59)]], {'required': False}), 61: ('wagtail.blocks.StructBlock', [[('bgImage', 0), ('bgColor', 1), ('bgOpacity', 2), ('fill_pattern', 3), ('fgColor', 4), ('fontType', 5), ('title', 6), ('main_title', 7), ('content', 60)]], {})}, null=True)),
                ('show_footer', models.BooleanField(blank=True, default=False, null=True)),
                ('show_footer_menu', models.BooleanField(blank=True, default=False, null=True)),
                ('menuIcon', models.CharField(blank=True, max_length=250, null=True, verbose_name='Menu Icon')),
                ('menuName', models.CharField(blank=True, max_length=100, null=True, verbose_name='Menu Name')),
            ],
            options={
                'abstract': False,
            },
            bases=('wagtailcore.page', models.Model),
        ),
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('coName', models.CharField(max_length=200, verbose_name='Company Name')),
                ('coEmail', models.EmailField(blank=True, max_length=254, null=True, verbose_name='Company Email')),
                ('coContact', models.CharField(blank=True, max_length=200, null=True, verbose_name='Company Contact')),
                ('coWeb', models.CharField(blank=True, max_length=200, null=True, verbose_name='Company Website')),
                ('coFav', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Company Favicon')),
                ('coLogo', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Company Logo')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CompanyClient',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('coClientName', models.CharField(max_length=200, verbose_name='Client Name')),
                ('coClientCompName', models.CharField(blank=True, max_length=200, null=True, verbose_name='Client Company Name')),
                ('coClientLoc', models.TextField(blank=True, null=True, verbose_name='Address')),
                ('coClientCompImage', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='wagtailimages.image', verbose_name='Client Company Logo')),
                ('comp', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='clients', to='web.company')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CompanyContact',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('coContactName', models.CharField(max_length=200, verbose_name='Contact Person Name')),
                ('coContactEmail', models.EmailField(blank=True, max_length=254, null=True, verbose_name='Email')),
                ('coContactPhone', models.CharField(blank=True, max_length=13, null=True, verbose_name='Phone')),
                ('comp', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='contacts', to='web.company')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CompanyLoc',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('coLocType', models.CharField(max_length=200, verbose_name='Location Type')),
                ('coLocAdd', models.TextField(blank=True, null=True, verbose_name='Address')),
                ('coLocState', models.CharField(blank=True, max_length=200, null=True, verbose_name='State')),
                ('coLocPin', models.IntegerField(blank=True, null=True, verbose_name='PIN')),
                ('comp', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='com_loc', to='web.company')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Enquiry',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True, verbose_name='Public identifier')),
                ('enqName', models.CharField(blank=True, max_length=100, null=True, verbose_name='Name')),
                ('enqEmail', models.EmailField(blank=True, max_length=254, null=True)),
                ('enqContact', models.CharField(blank=True, max_length=20, null=True, verbose_name='Contact')),
                ('enqCompany', models.CharField(blank=True, max_length=100, null=True)),
                ('enqMessage', models.TextField(blank=True, null=True)),
                ('enqCreatedOn', models.DateTimeField(auto_now_add=True, verbose_name='Date')),
                ('enqStatus', models.CharField(blank=True, default='Pending', max_length=100, null=True)),
                ('enqProduct', models.CharField(blank=True, max_length=200, null=True)),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='replies', to='web.enquiry')),
            ],
            options={
                'ordering': ['-enqCreatedOn'],
            },
        ),
        migrations.CreateModel(
            name='FollowUp',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True, verbose_name='Public identifier')),
                ('detail', wagtail.fields.RichTextField(blank=True, null=True)),
                ('assignTo', models.CharField(blank=True, max_length=200, null=True)),
                ('remarks', models.TextField(blank=True, null=True)),
                ('enqCreatedOn', models.DateTimeField(auto_now_add=True)),
                ('enquiry', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='followup', to='web.enquiry')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='replie_follow', to='web.followup')),
            ],
            options={
                'ordering': ['-enqCreatedOn'],
            },
        ),
        migrations.CreateModel(
            name='Industry',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('industryName', models.CharField(max_length=200, verbose_name='Industry Name')),
                ('industryDetail', wagtail.fields.RichTextField(blank=True, null=True, verbose_name='Industry Detail')),
                ('industryImage', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='wagtailimages.image', verbose_name='Industry Image')),
            ],
            options={
                'verbose_name': 'Industry',
                'verbose_name_plural': 'Industries',
            },
        ),
        migrations.CreateModel(
            name='Menu',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=150)),
                ('icon', models.CharField(blank=True, max_length=150, null=True)),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, null=True, populate_from='title')),
                ('is_dropdown', models.BooleanField(blank=True, default=False, null=True)),
                ('color', wagtail_color_panel.fields.ColorField(blank=True, default='#000000', max_length=7, null=True, verbose_name='Color')),
                ('imgIcon', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Image Icon')),
                ('page', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='wagtailcore.page')),
            ],
            options={
                'verbose_name': 'Menu',
            },
        ),
        migrations.CreateModel(
            name='ServiceCat',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200)),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='title', unique=True)),
                ('short_desc', wagtail.fields.RichTextField(blank=True, null=True, verbose_name='Short Description')),
                ('detail', wagtail.fields.RichTextField(blank=True, null=True)),
                ('image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Service Image')),
                ('imgIcon', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Image Icon')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Services',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('title', models.CharField(max_length=200)),
                ('title_animation', models.CharField(blank=True, choices=[('l2r', 'Left to Right'), ('r2l', 'Right to Left'), ('t2b', 'Top to Bottom'), ('b2t', 'Bottom to Top')], default='l2r', max_length=200, null=True)),
                ('title_duration', models.IntegerField(blank=True, default=2, null=True)),
                ('icon', models.CharField(blank=True, max_length=200, null=True)),
                ('slug', models.CharField(blank=True, max_length=255, unique=True)),
                ('img_animation', models.CharField(blank=True, choices=[('l2r', 'Left to Right'), ('r2l', 'Right to Left'), ('t2b', 'Top to Bottom'), ('b2t', 'Bottom to Top')], default='l2r', max_length=200, null=True)),
                ('img_duration', models.IntegerField(blank=True, default=2, null=True)),
                ('short_desc', wagtail.fields.RichTextField(blank=True, null=True, verbose_name='Short Description')),
                ('detail', wagtail.fields.RichTextField(blank=True, null=True)),
                ('detail_animation', models.CharField(blank=True, choices=[('l2r', 'Left to Right'), ('r2l', 'Right to Left'), ('t2b', 'Top to Bottom'), ('b2t', 'Bottom to Top')], default='l2r', max_length=200, null=True)),
                ('detail_duration', models.IntegerField(blank=True, default=2, null=True)),
                ('cat', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='services', to='web.servicecat')),
                ('image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Service Image')),
                ('imgIcon', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Image Icon')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MenuItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('title', models.CharField(blank=True, max_length=150, null=True)),
                ('icon', models.CharField(blank=True, max_length=150, null=True)),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, null=True, populate_from='title')),
                ('document', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='wagtaildocs.document')),
                ('imgIcon', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Image Icon')),
                ('menu', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='menu_items', to='web.menu', verbose_name='Sub Menu')),
                ('page', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='wagtailcore.page')),
                ('service', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='web.services', verbose_name='Service')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceSubCat',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('title', models.CharField(max_length=200)),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='title', unique=True)),
                ('short_desc', wagtail.fields.RichTextField(blank=True, null=True)),
                ('detail', wagtail.fields.RichTextField(blank=True, null=True)),
                ('cat', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='sub_categories', to='web.servicecat')),
                ('image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Service Image')),
                ('imgIcon', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Image Icon')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Social',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('soTitle', models.CharField(blank=True, help_text='Social Plateform Name e.g: Facebook,Instagram', max_length=255, null=True, verbose_name='Title')),
                ('soLogoText', models.CharField(blank=True, max_length=250, null=True, verbose_name='Logo Text')),
                ('soUrl', models.CharField(help_text='For Whatsapp use https://wa.me/8859XXXXXX', max_length=255, null=True, verbose_name='URL')),
                ('BgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG')),
                ('FgColor', wagtail_color_panel.fields.ColorField(default='#000000', max_length=7, verbose_name='FG')),
                ('hoverBgColor', wagtail_color_panel.fields.ColorField(default='#FFFFFF', max_length=7, verbose_name='BG')),
                ('hoverFgColor', wagtail_color_panel.fields.ColorField(default='#000000', max_length=7, verbose_name='FG')),
                ('soLogo', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Icon')),
            ],
            options={
                'verbose_name_plural': 'Social',
                'ordering': ['soTitle'],
            },
        ),
    ]
