from rest_framework import serializers

from .models import *
from core.serializers import ImageSerializer

from wagtail.images import get_image_model
from wagtail.images.shortcuts import get_rendition_or_not_found
from wagtail.api.v2.views import BaseSerializer

Image = get_image_model()

class BannerContentImageSerializer(serializers.Serializer):
    id = serializers.IntegerField()
    alt = serializers.CharField(source="title")
    src = serializers.SerializerMethodField()
    srcSet = serializers.SerializerMethodField()

    def get_src(self, image):
        return image.file.url

    def get_srcSet(self, image):
        sizes = [400, 800, 1200]
        renditions = [
            f"{get_rendition_or_not_found(image, f'width-{size}').url} {size}w"
            for size in sizes
        ]
        return ", ".join(renditions)


def serialize_bannercontent(bannercontent):
    serialized = []
    for block in bannercontent:
        if block.block_type == 'slide':
            slide_data = block.value
            image = slide_data.get('image')
            if isinstance(image, Image):
                image_data = BannerContentImageSerializer(image).data
                slide_data['image'] = image_data
        serialized.append({
            'type': block.block_type,
            'value': slide_data,
        })
    return serialized


class PolicySerializer(serializers.ModelSerializer):
    class Meta:
        model = Policy
        fields = ['id','title','slug','detail']

class MenuItemSerializer(serializers.ModelSerializer):
    # image=ImageSerializer()
    class Meta:
        model = MenuItem
        fields = "__all__"
        depth=2


class FooterSerializer(serializers.ModelSerializer):
    # image=ImageSerializer()
    class Meta:
        model = Footer
        fields = "__all__"


class IndustrySerializer(serializers.ModelSerializer):
    industryImage=ImageSerializer()
    class Meta:
        model = Industry
        fields = "__all__"


class ServiceCatSerializer(serializers.ModelSerializer):
    image=ImageSerializer()
    # image = serializers.SerializerMethodField()

    class Meta:
        model = ServiceCat
        fields = ['id', 'title', 'slug', 'image', 'short_desc', 'detail']
    # def get_image(self, obj):
    #     if obj.image:
    #         return {
    #             'id': obj.image.id,
    #             'title': obj.image.title,
    #             'file': obj.image.file.url
    #         }
    #     return None
    
class ServiceSubCatSerializer(serializers.ModelSerializer):
    image=ImageSerializer()
    class Meta:
        model = ServiceSubCat
        fields = "__all__"

class ServiceSerializer(serializers.ModelSerializer):
    image=ImageSerializer()
    imgIcon=ImageSerializer()
    cat_slug = serializers.SlugRelatedField(
        source='cat',
        read_only=True,
        slug_field='slug'
    )
    class Meta:
        model = Services
        fields = ['id','title','slug','image','short_desc','cat_slug','detail','icon','imgIcon','title_animation','title_duration','img_animation','img_duration','detail_animation','detail_duration']

class ServiceDetailSerializer(serializers.ModelSerializer):
    image=ImageSerializer()
    class Meta:
        model = Services
        fields = ['id','title','slug','image','short_desc','detail']

class BottomFooterSerializer(serializers.ModelSerializer):
    class Meta:
        model = BottomFooter
        fields = "__all__"
        # depth=2

class FollowUpSerializer(serializers.ModelSerializer):
    class Meta:
        model = FollowUp
        fields = "__all__"
        

class EnquiryDetailSerializer(serializers.ModelSerializer):
    followup=FollowUpSerializer(many=True)
    class Meta:
        model = Enquiry
        fields = ['id','enqName','enqEmail','enqContact','enqCompany','enqMessage','enqCreatedOn','enqStatus','followup']
        
class EnquirySerializer(serializers.ModelSerializer):
    class Meta:
        model = Enquiry
        fields = "__all__"
        depth=2

class WebPageSerializer(serializers.ModelSerializer):
    class Meta:
        model = WebPage
        fields = ['id','title','slug','bannerHeight','bannerWidth','bannerTimer','bannercontent','body']
        depth=2


class CompanyLocSerializer(serializers.ModelSerializer):
    class Meta:
        model = CompanyLoc
        fields = "__all__"

class CompanyClientSerializer(serializers.ModelSerializer):
    coClientCompImage=ImageSerializer()
    class Meta:
        model = CompanyClient
        fields = ['id','coClientName','coClientCompImage']


class CompanySerializer(serializers.ModelSerializer):
    com_loc=CompanyLocSerializer(many=True)
    clients=CompanyClientSerializer(many=True)
    coLogo=ImageSerializer()
    class Meta:
        model = Company
        fields = ['id','coName','coEmail','coContact','coWeb','com_loc','clients','coLogo']
        depth=2
