# api.py
from .views import *
from wagtail.api.v2.views import PagesAPIViewSet
from wagtail.api.v2.router import WagtailAPIRouter
from wagtail.images.api.v2.views import ImagesAPIViewSet
from wagtail.documents.api.v2.views import DocumentsAPIViewSet

# Create the router. "wagtailapi" is the URL namespace
api_router = WagtailAPIRouter('wagtailapi')

# Add the three endpoints using the "register_endpoint" method.
# The first parameter is the name of the endpoint (such as pages, images). This
# is used in the URL of the endpoint
# The second parameter is the endpoint class that handles the requests
api_router.register_endpoint('pages', PagesAPIViewSet)
api_router.register_endpoint('page', WebPageView)
api_router.register_endpoint('images', ImagesAPIViewSet)
api_router.register_endpoint('documents', DocumentsAPIViewSet)

api_router.register_endpoint('headers', HeaderAPIEndpoint)
api_router.register_endpoint('footer', FooterAPIEndpoint)
api_router.register_endpoint('bottom-footer', BottomFooterAPIEndpoint)


from rest_framework.routers import DefaultRouter
router = DefaultRouter()
router.register(r'service-cat', ServiceCatViewSet)
# router.register(r'footer', FooterViewSet)
# 
from django.urls import path, include,re_path

urlpatterns = [
    path('', api_router.urls),
    path('', include(router.urls)),
    path('company/',CompanyView.as_view()),
    path('services/',ServiceListView.as_view()),
    path('enquiry/',EnquiryView.as_view()),
    path('enquiry-list/',EnquiryListView.as_view()),
    path('enquiry/<id>/',EnquiryDetailView.as_view()),
    path('enquiry-done/<id>/',EnquiryDoneView.as_view()),
    path('industry/',IndustryView.as_view()),
    # path('service-sub-cat/<slug>/',ServiceSubCatView.as_view()),
    path('policy/<slug>/',PolicyView.as_view()),
    path('services/<slug>/',ServiceView.as_view()),
    path('service/<slug>/',ServiceDetailView.as_view()),
    path('menu-items/<slug>/',MenuItemsView.as_view()),
    # path('web-page/<slug>/',WebPageView.as_view()),
    
    
]
