from wagtail_modeladmin.options import (
    ModelAdmin,
    ModelAdminGroup,
    modeladmin_register,
)
from .models import *
from django.templatetags.static import static
from django.utils.safestring import mark_safe
from wagtail import hooks

# @hooks.register('insert_global_admin_js')
# def register_admin_js():
#     subcategory_chooser_js = static('js/subcategory_chooser.js')
#     return mark_safe(f'<script src="{subcategory_chooser_js}"></script>')


@hooks.register('insert_global_admin_js')
def register_admin_js():
    js_files = [
        static('js/menuitem_autofill.js'),
        static('js/subcategory_chooser.js'),
        # static('js/yet_another_script.js'),
    ]
    script_tags = [f'<script src="{js_file}"></script>' for js_file in js_files]
    return mark_safe('\n'.join(script_tags))



@hooks.register('insert_global_admin_css')
def register_admin_css():
    subcategory_chooser_css = static('css/subcategory_chooser.css')
    return mark_safe(f'<link rel="stylesheet" href="{subcategory_chooser_css}">')

@modeladmin_register
class CompanyAdmin(ModelAdmin):
    model = Company
    menu_label = "Company"  # ditch this to use verbose_name_plural from model
    menu_icon = "home"  # change as required
    list_display = ("coName",)
    list_filter = list_display
    search_fields = list_display

@modeladmin_register
class ServiceCatAdmin(ModelAdmin):
    model = ServiceCat
    menu_label = "Category & Services"  # ditch this to use verbose_name_plural from model
    menu_icon = "cogs"  # change as required
    list_display = ("title",)
    list_filter = list_display
    search_fields = list_display



